/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.security;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.ebpm.messaging.api.Message;

public class SecurityToken {
    private static transient ObjectMapper mapper = new ObjectMapper();
    private String commonName;
    private String organizationalUnit;
    private String organization;
    private String locality;
    private String state;
    private String country;
    private Map<String, String> properties = new HashMap<String, String>();

    public SecurityToken() {
    }

    public SecurityToken(String commonName) {
        this();
        this.commonName = commonName;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public String getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public void setOrganizationalUnit(String organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static void saveInMessage(SecurityToken securityToken, Message message) {
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, (Object)securityToken);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        message.setHeader("org.spagic3.security.token", (Object)writer.toString());
    }

    public static SecurityToken loadFromMessage(Message message) {
        try {
            return (SecurityToken)mapper.readValue((String)message.getHeader("org.spagic3.security.token"), SecurityToken.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

