/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;

public class PythonCodeFactory
extends AbstractCodeFactory {
    public static List<String> RESERVED_KEYWORDS = new ArrayList<String>();

    static {
        RESERVED_KEYWORDS.add("and");
        RESERVED_KEYWORDS.add("as");
        RESERVED_KEYWORDS.add("assert");
        RESERVED_KEYWORDS.add("break");
        RESERVED_KEYWORDS.add("class");
        RESERVED_KEYWORDS.add("continue");
        RESERVED_KEYWORDS.add("def");
        RESERVED_KEYWORDS.add("del");
        RESERVED_KEYWORDS.add("elif");
        RESERVED_KEYWORDS.add("else");
        RESERVED_KEYWORDS.add("except");
        RESERVED_KEYWORDS.add("exec");
        RESERVED_KEYWORDS.add("finally");
        RESERVED_KEYWORDS.add("for");
        RESERVED_KEYWORDS.add("from");
        RESERVED_KEYWORDS.add("global");
        RESERVED_KEYWORDS.add("if");
        RESERVED_KEYWORDS.add("import");
        RESERVED_KEYWORDS.add("in");
        RESERVED_KEYWORDS.add("is");
        RESERVED_KEYWORDS.add("lambda");
        RESERVED_KEYWORDS.add("not");
        RESERVED_KEYWORDS.add("or");
        RESERVED_KEYWORDS.add("pass");
        RESERVED_KEYWORDS.add("print");
        RESERVED_KEYWORDS.add("raise");
        RESERVED_KEYWORDS.add("return");
        RESERVED_KEYWORDS.add("try");
        RESERVED_KEYWORDS.add("while");
        RESERVED_KEYWORDS.add("with");
        RESERVED_KEYWORDS.add("yield");
    }

    public String createFunctionWrapper(IEnvironment environment, String moduleVariable, Method method) {
        StringBuilder pythonCode = new StringBuilder();
        List parameters = ModuleHelper.getParameters((Method)method);
        StringBuilder methodSignature = new StringBuilder();
        StringBuilder methodCall = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            methodSignature.append(", ").append(parameter.getName());
            methodCall.append(", ").append(parameter.getName());
            if (!parameter.isOptional()) continue;
            methodSignature.append(" = ").append(this.getDefaultValue(parameter));
        }
        if (methodSignature.length() > 2) {
            methodSignature.delete(0, 2);
            methodCall.delete(0, 2);
        }
        StringBuilder body = new StringBuilder();
        body.append(PythonCodeFactory.getPreExecutionCode((IEnvironment)environment, (Method)method));
        body.append('\t').append("__result").append(" = ").append(moduleVariable).append('.').append(method.getName()).append('(');
        body.append((CharSequence)methodCall);
        body.append(")\n");
        body.append(PythonCodeFactory.getPostExecutionCode((IEnvironment)environment, (Method)method));
        body.append("\treturn ").append("__result").append('\n');
        for (String name : PythonCodeFactory.getMethodNames((Method)method)) {
            if (!this.isValidMethodName(name)) {
                Logger.error((String)"org.eclipse.ease.lang.python", (String)("The method name \"" + name + "\" from the module \"" + moduleVariable + "\" can not be wrapped because it's name is reserved"));
                continue;
            }
            if (name.isEmpty()) continue;
            pythonCode.append("def ").append(name).append('(').append((CharSequence)methodSignature).append("):\n");
            pythonCode.append((CharSequence)body);
            pythonCode.append('\n');
        }
        return pythonCode.toString();
    }

    public String getSaveVariableName(String variableName) {
        return PythonHelper.getSaveName(variableName);
    }

    public String classInstantiation(Class<?> clazz, String[] parameters) {
        StringBuilder code = new StringBuilder();
        code.append(clazz.getCanonicalName());
        code.append('(');
        if (parameters != null) {
            String[] stringArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                code.append(parameter);
                code.append(", ");
                ++n2;
            }
            if (parameters.length > 0) {
                code.delete(code.length() - 2, code.length());
            }
        }
        code.append(')');
        return code.toString();
    }

    public boolean isValidMethodName(String methodName) {
        return PythonHelper.isSaveName(methodName) && !RESERVED_KEYWORDS.contains(methodName);
    }

    public String createFinalFieldWrapper(IEnvironment environment, String moduleVariable, Field field) {
        return String.valueOf(PythonHelper.getSaveName(field.getName())) + " = " + moduleVariable + '.' + field.getName() + '\n';
    }

    protected String getNullString() {
        return "None";
    }

    protected String getTrueString() {
        return "True";
    }

    protected String getFalseString() {
        return "False";
    }

    protected String getSingleLineCommentToken() {
        return "# ";
    }

    protected String getMultiLineCommentStartToken() {
        return "\"\"\"";
    }

    protected String getMultiLineCommentEndToken() {
        return this.getMultiLineCommentStartToken();
    }
}

