/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.impl.JDependencyInfoImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;

public class JDependencyInfos {
    public static Set<JDependencyInfo> getDependenciesFromDirectory(String directory) throws IOException {
        return JDependencyInfos.getDependenciesFromDirectory(new File(directory));
    }

    public static Set<JDependencyInfo> getDependenciesFromDirectory(File directory) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<java.nio.file.Path> files = Files.walk(Paths.get(directory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            return files.filter(p -> JDependencyInfos.isDependencyFile(p.toFile())).map(p -> new JDependencyInfoImpl(p.toFile())).collect(Collectors.toSet());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static JDependencyInfo getDependencyFromBundleId(String bundleId) throws IOException {
        File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)bundleId));
        if (JDependencyInfos.isEclipseProject(bundleFile)) {
            return JDependencyInfos.create(new File(bundleFile, "target/classes"));
        }
        return JDependencyInfos.create(bundleFile);
    }

    public static JDependencyInfo getDependencyFromBundle(String bundle, String path) throws IOException {
        return JDependencyInfos.getDependencyFromBundle(Platform.getBundle((String)bundle), new Path(path));
    }

    public static JDependencyInfo getDependencyFromBundle(Bundle bundle, Path path) throws IOException {
        URL jarUrl = FileLocator.find((Bundle)bundle, (IPath)path);
        if (jarUrl == null) {
            throw new IOException("No dependency found in bundle '" + bundle + "' at '" + path + "'");
        }
        URL jarFileUrl = FileLocator.toFileURL((URL)jarUrl);
        try {
            return JDependencyInfos.create(URIUtil.toFile((URI)URIUtil.toURI((URL)jarFileUrl)));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public static boolean isDependencyFile(File file) {
        return file != null && file.isFile() && JDependencyInfos.isValidDependencyExtension(file);
    }

    private static boolean isValidDependencyExtension(File file) {
        String fileName = file.getAbsolutePath();
        return fileName.endsWith(".jar") || fileName.endsWith(".war") && fileName.endsWith(".class");
    }

    public static JDependencyInfo create(File jarFile) {
        return new JDependencyInfoImpl(jarFile);
    }

    public static List<String> toClasspathList(Collection<JDependencyInfo> dependencyInfos) {
        return dependencyInfos.stream().map(d -> d.getLocation().getAbsolutePath()).collect(Collectors.toList());
    }

    public static String toClasspath(Collection<JDependencyInfo> dependencyInfos) {
        return JDependencyInfos.toClasspathList(dependencyInfos).stream().collect(Collectors.joining(JDependencyInfos.getClasspathSeparator()));
    }

    static CharSequence getClasspathSeparator() {
        String val = System.getProperty("path.separator");
        if (val == null) {
            throw new IllegalArgumentException("system property 'path.seaprator' must not be null");
        }
        return val;
    }

    static boolean isEclipseProject(File bundleFile) {
        if (!bundleFile.isDirectory()) {
            return false;
        }
        if (!new File(bundleFile, "target/classes").exists()) {
            return false;
        }
        File pFile = new File(bundleFile, ".project");
        return pFile.exists() && pFile.isFile();
    }
}

