/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileLogger } from "./FileLogger";
/**
 * Simple singleton logger with 4 log levels.
 *
 * Log levels:
 * - DEBUG: Fine-grained, noisy, excessively detailed, and mostly irrelevant messages.
 * - INFO: Coarse-grained messages related to the high-level inner workings of the code.
 * - ERROR: Errors which are bad, but not entirely unexpected, such as errors I/O errors when
 *          running on a flaky network connection.
 * - SEVERE: Unexpected errors that strongly suggest a client/server implementation bug or a
 *           serious client/server runtime issue.
 */
export declare enum LogLevel {
    DEBUG = 1,
    INFO = 2,
    ERROR = 3,
    SEVERE = 4
}
export declare class LogSettings {
    logLevel: LogLevel;
    static getInstance(): LogSettings;
    private static instance;
    private _logLevel;
    private _startTimeInMsecs;
    private _fileLogger;
    private _outputLogsToScreen;
    constructor();
    generatePrefix(): string;
    setOutputLogsToScreen(outputToScreen: boolean): void;
    setFileLogger(fileLogger: FileLogger): void;
    internalGetFileLogger(): FileLogger;
    readonly outputLogsToScreen: boolean;
}
export declare function setLogLevel(l: LogLevel): void;
export declare function debug(str: string): void;
export declare function info(str: string): void;
export declare function error(str: string, err?: Error): void;
export declare function severe(str: string, err?: Error): void;
export declare function logLevelToString(l: LogLevel): "DEBUG" | "ERROR" | "INFO" | "SEVERE";
