/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorInput;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenAppOverviewAction
implements IObjectActionDelegate {
    protected CodewindApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"OpenAppOverviewAction ran but no application was selected");
            return;
        }
        OpenAppOverviewAction.openAppOverview(this.app);
    }

    public static void openAppOverview(CodewindApplication app) {
        IWorkbenchWindow workbenchWindow = CodewindUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        try {
            ApplicationOverviewEditorInput input = new ApplicationOverviewEditorInput(app);
            IEditorPart part = page.openEditor((IEditorInput)input, "org.eclipse.codewind.ui.editors.appOverview");
            if (!(part instanceof ApplicationOverviewEditorPart)) {
                Logger.logError((String)("Application overview editor part for the " + app.name + " application is the wrong type: " + part.getClass()));
            }
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred opening the editor for application: " + app.name), (Throwable)e);
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

