/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.ode.Parameterizable;
import org.apache.commons.math3.ode.UnknownParameterException;

public abstract class AbstractParameterizable
implements Parameterizable {
    private final Collection<String> parametersNames = new ArrayList<String>();

    protected AbstractParameterizable(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.parametersNames.add(name);
            ++n2;
        }
    }

    protected AbstractParameterizable(Collection<String> names) {
        this.parametersNames.addAll(names);
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.parametersNames;
    }

    @Override
    public boolean isSupported(String name) {
        for (String supportedName : this.parametersNames) {
            if (!supportedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void complainIfNotSupported(String name) throws UnknownParameterException {
        if (!this.isSupported(name)) {
            throw new UnknownParameterException(name);
        }
    }
}

