/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.ArrayList;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.DefaultFieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultFieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldMatrixChangingVisitor;
import org.apache.commons.math3.linear.FieldMatrixPreservingVisitor;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.util.MathArrays;

public abstract class AbstractFieldMatrix<T extends FieldElement<T>>
implements FieldMatrix<T> {
    private final Field<T> field;

    protected AbstractFieldMatrix() {
        this.field = null;
    }

    protected AbstractFieldMatrix(Field<T> field) {
        this.field = field;
    }

    protected AbstractFieldMatrix(Field<T> field, int rowDimension, int columnDimension) throws NotStrictlyPositiveException {
        if (rowDimension <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, rowDimension);
        }
        if (columnDimension <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, columnDimension);
        }
        this.field = field;
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[][] d) throws NoDataException, NullArgumentException {
        if (d == null) {
            throw new NullArgumentException();
        }
        if (d.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        if (d[0].length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        return d[0][0].getField();
    }

    protected static <T extends FieldElement<T>> Field<T> extractField(T[] d) throws NoDataException {
        if (d.length == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        return d[0].getField();
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[][] buildArray(Field<T> field, int rows, int columns) {
        return (FieldElement[][])MathArrays.buildArray(field, rows, columns);
    }

    @Deprecated
    protected static <T extends FieldElement<T>> T[] buildArray(Field<T> field, int length) {
        return (FieldElement[])MathArrays.buildArray(field, length);
    }

    @Override
    public Field<T> getField() {
        return this.field;
    }

    @Override
    public abstract FieldMatrix<T> createMatrix(int var1, int var2) throws NotStrictlyPositiveException;

    @Override
    public abstract FieldMatrix<T> copy();

    @Override
    public FieldMatrix<T> add(FieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkAdditionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).add(m.getEntry(row, col)));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> subtract(FieldMatrix<T> m) throws MatrixDimensionMismatchException {
        this.checkSubtractionCompatible(m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).subtract(m.getEntry(row, col)));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarAdd(T d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).add(d));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> scalarMultiply(T d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(rowCount, columnCount);
        int row = 0;
        while (row < rowCount) {
            int col = 0;
            while (col < columnCount) {
                out.setEntry(row, col, (FieldElement)this.getEntry(row, col).multiply(d));
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> multiply(FieldMatrix<T> m) throws DimensionMismatchException {
        this.checkMultiplicationCompatible(m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        FieldMatrix<FieldElement> out = this.createMatrix(nRows, nCols);
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                FieldElement sum = (FieldElement)this.field.getZero();
                int i = 0;
                while (i < nSum) {
                    sum = sum.add((FieldElement)this.getEntry(row, i).multiply(m.getEntry(i, col)));
                    ++i;
                }
                out.setEntry(row, col, sum);
                ++col;
            }
            ++row;
        }
        return out;
    }

    @Override
    public FieldMatrix<T> preMultiply(FieldMatrix<T> m) throws DimensionMismatchException {
        return m.multiply(this);
    }

    @Override
    public FieldMatrix<T> power(int p) throws NonSquareMatrixException, NotPositiveException {
        if (p < 0) {
            throw new NotPositiveException(p);
        }
        if (!this.isSquare()) {
            throw new NonSquareMatrixException(this.getRowDimension(), this.getColumnDimension());
        }
        if (p == 0) {
            return MatrixUtils.createFieldIdentityMatrix(this.getField(), this.getRowDimension());
        }
        if (p == 1) {
            return this.copy();
        }
        int power = p - 1;
        char[] binaryRepresentation = Integer.toBinaryString(power).toCharArray();
        ArrayList<Integer> nonZeroPositions = new ArrayList<Integer>();
        int i = 0;
        while (i < binaryRepresentation.length) {
            if (binaryRepresentation[i] == '1') {
                int pos = binaryRepresentation.length - i - 1;
                nonZeroPositions.add(pos);
            }
            ++i;
        }
        ArrayList results = new ArrayList(binaryRepresentation.length);
        results.add(0, this.copy());
        int i2 = 1;
        while (i2 < binaryRepresentation.length) {
            FieldMatrix s = (FieldMatrix)results.get(i2 - 1);
            FieldMatrix r = s.multiply(s);
            results.add(i2, r);
            ++i2;
        }
        FieldMatrix<T> result = this.copy();
        for (Integer i3 : nonZeroPositions) {
            result = result.multiply((FieldMatrix)results.get(i3));
        }
        return result;
    }

    @Override
    public T[][] getData() {
        FieldElement[][] data = (FieldElement[][])MathArrays.buildArray(this.field, this.getRowDimension(), this.getColumnDimension());
        int i = 0;
        while (i < data.length) {
            FieldElement[] dataI = data[i];
            int j = 0;
            while (j < dataI.length) {
                dataI[j] = this.getEntry(i, j);
                ++j;
            }
            ++i;
        }
        return data;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        FieldMatrix<T> subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        int i = startRow;
        while (i <= endRow) {
            int j = startColumn;
            while (j <= endColumn) {
                subMatrix.setEntry(i - startRow, j - startColumn, this.getEntry(i, j));
                ++j;
            }
            ++i;
        }
        return subMatrix;
    }

    @Override
    public FieldMatrix<T> getSubMatrix(final int[] selectedRows, final int[] selectedColumns) throws NoDataException, NullArgumentException, OutOfRangeException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        FieldMatrix<T> subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder(new DefaultFieldMatrixChangingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public T visit(int row, int column, T value) {
                return AbstractFieldMatrix.this.getEntry(selectedRows[row], selectedColumns[column]);
            }
        });
        return subMatrix;
    }

    @Override
    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, T[][] destination) throws MatrixDimensionMismatchException, NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw new MatrixDimensionMismatchException(destination.length, destination[0].length, rowsCount, columnsCount);
        }
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero(), (FieldElement[][])destination){
            private int startRow;
            private int startColumn;
            private final /* synthetic */ FieldElement[][] val$destination;
            {
                this.val$destination = fieldElementArray;
                super($anonymous0);
            }

            @Override
            public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
                this.startRow = startRow;
                this.startColumn = startColumn;
            }

            @Override
            public void visit(int row, int column, T value) {
                this.val$destination[row - this.startRow][column - this.startColumn] = value;
            }
        }, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, T[][] destination) throws MatrixDimensionMismatchException, NoDataException, NullArgumentException, OutOfRangeException {
        this.checkSubMatrixIndex(selectedRows, selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw new MatrixDimensionMismatchException(destination.length, destination[0].length, selectedRows.length, selectedColumns.length);
        }
        int i = 0;
        while (i < selectedRows.length) {
            T[] destinationI = destination[i];
            int j = 0;
            while (j < selectedColumns.length) {
                destinationI[j] = this.getEntry(selectedRows[i], selectedColumns[j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setSubMatrix(T[][] subMatrix, int row, int column) throws DimensionMismatchException, OutOfRangeException, NoDataException, NullArgumentException {
        if (subMatrix == null) {
            throw new NullArgumentException();
        }
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_ROW);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw new NoDataException(LocalizedFormats.AT_LEAST_ONE_COLUMN);
        }
        int r = 1;
        while (r < nRows) {
            if (subMatrix[r].length != nCols) {
                throw new DimensionMismatchException(nCols, subMatrix[r].length);
            }
            ++r;
        }
        this.checkRowIndex(row);
        this.checkColumnIndex(column);
        this.checkRowIndex(nRows + row - 1);
        this.checkColumnIndex(nCols + column - 1);
        int i = 0;
        while (i < nRows) {
            int j = 0;
            while (j < nCols) {
                this.setEntry(row + i, column + j, subMatrix[i][j]);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public FieldMatrix<T> getRowMatrix(int row) throws OutOfRangeException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        FieldMatrix<T> out = this.createMatrix(1, nCols);
        int i = 0;
        while (i < nCols) {
            out.setEntry(0, i, this.getEntry(row, i));
            ++i;
        }
        return out;
    }

    @Override
    public void setRowMatrix(int row, FieldMatrix<T> matrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new MatrixDimensionMismatchException(matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols);
        }
        int i = 0;
        while (i < nCols) {
            this.setEntry(row, i, matrix.getEntry(0, i));
            ++i;
        }
    }

    @Override
    public FieldMatrix<T> getColumnMatrix(int column) throws OutOfRangeException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        FieldMatrix<T> out = this.createMatrix(nRows, 1);
        int i = 0;
        while (i < nRows) {
            out.setEntry(i, 0, this.getEntry(i, column));
            ++i;
        }
        return out;
    }

    @Override
    public void setColumnMatrix(int column, FieldMatrix<T> matrix) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new MatrixDimensionMismatchException(matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1);
        }
        int i = 0;
        while (i < nRows) {
            this.setEntry(i, column, matrix.getEntry(i, 0));
            ++i;
        }
    }

    @Override
    public FieldVector<T> getRowVector(int row) throws OutOfRangeException {
        return new ArrayFieldVector(this.field, this.getRow(row), false);
    }

    @Override
    public void setRowVector(int row, FieldVector<T> vector) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new MatrixDimensionMismatchException(1, vector.getDimension(), 1, nCols);
        }
        int i = 0;
        while (i < nCols) {
            this.setEntry(row, i, vector.getEntry(i));
            ++i;
        }
    }

    @Override
    public FieldVector<T> getColumnVector(int column) throws OutOfRangeException {
        return new ArrayFieldVector(this.field, this.getColumn(column), false);
    }

    @Override
    public void setColumnVector(int column, FieldVector<T> vector) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new MatrixDimensionMismatchException(vector.getDimension(), 1, nRows, 1);
        }
        int i = 0;
        while (i < nRows) {
            this.setEntry(i, column, vector.getEntry(i));
            ++i;
        }
    }

    @Override
    public T[] getRow(int row) throws OutOfRangeException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
        int i = 0;
        while (i < nCols) {
            out[i] = this.getEntry(row, i);
            ++i;
        }
        return out;
    }

    @Override
    public void setRow(int row, T[] array) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkRowIndex(row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new MatrixDimensionMismatchException(1, array.length, 1, nCols);
        }
        int i = 0;
        while (i < nCols) {
            this.setEntry(row, i, array[i]);
            ++i;
        }
    }

    @Override
    public T[] getColumn(int column) throws OutOfRangeException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
        int i = 0;
        while (i < nRows) {
            out[i] = this.getEntry(i, column);
            ++i;
        }
        return out;
    }

    @Override
    public void setColumn(int column, T[] array) throws OutOfRangeException, MatrixDimensionMismatchException {
        this.checkColumnIndex(column);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new MatrixDimensionMismatchException(array.length, 1, nRows, 1);
        }
        int i = 0;
        while (i < nRows) {
            this.setEntry(i, column, array[i]);
            ++i;
        }
    }

    @Override
    public abstract T getEntry(int var1, int var2) throws OutOfRangeException;

    @Override
    public abstract void setEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public abstract void addToEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public abstract void multiplyEntry(int var1, int var2, T var3) throws OutOfRangeException;

    @Override
    public FieldMatrix<T> transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        final FieldMatrix<T> out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder(new DefaultFieldMatrixPreservingVisitor<T>((FieldElement)this.field.getZero()){

            @Override
            public void visit(int row, int column, T value) {
                out.setEntry(column, row, value);
            }
        });
        return out;
    }

    @Override
    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Override
    public abstract int getRowDimension();

    @Override
    public abstract int getColumnDimension();

    @Override
    public T getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        FieldElement trace = (FieldElement)this.field.getZero();
        int i = 0;
        while (i < nRows) {
            trace = (FieldElement)trace.add(this.getEntry(i, i));
            ++i;
        }
        return (T)trace;
    }

    @Override
    public T[] operate(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw new DimensionMismatchException(v.length, nCols);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
        int row = 0;
        while (row < nRows) {
            FieldElement sum = (FieldElement)this.field.getZero();
            int i = 0;
            while (i < nCols) {
                sum = sum.add((FieldElement)this.getEntry(row, i).multiply(v[i]));
                ++i;
            }
            out[row] = sum;
            ++row;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> operate(FieldVector<T> v) throws DimensionMismatchException {
        try {
            return new ArrayFieldVector(this.field, this.operate(((ArrayFieldVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nCols) {
                throw new DimensionMismatchException(v.getDimension(), nCols);
            }
            out = (FieldElement[])MathArrays.buildArray(this.field, nRows);
            row = 0;
            ** while (row < nRows)
        }
lbl-1000:
        // 1 sources

        {
            sum = (FieldElement)this.field.getZero();
            i = 0;
            while (i < nCols) {
                sum = sum.add((FieldElement)this.getEntry(row, i).multiply(v.getEntry(i)));
                ++i;
            }
            out[row] = sum;
            ++row;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayFieldVector(this.field, out, false);
    }

    @Override
    public T[] preMultiply(T[] v) throws DimensionMismatchException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw new DimensionMismatchException(v.length, nRows);
        }
        FieldElement[] out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
        int col = 0;
        while (col < nCols) {
            FieldElement sum = (FieldElement)this.field.getZero();
            int i = 0;
            while (i < nRows) {
                sum = sum.add((FieldElement)this.getEntry(i, col).multiply(v[i]));
                ++i;
            }
            out[col] = sum;
            ++col;
        }
        return out;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public FieldVector<T> preMultiply(FieldVector<T> v) throws DimensionMismatchException {
        try {
            return new ArrayFieldVector(this.field, this.preMultiply(((ArrayFieldVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            nRows = this.getRowDimension();
            nCols = this.getColumnDimension();
            if (v.getDimension() != nRows) {
                throw new DimensionMismatchException(v.getDimension(), nRows);
            }
            out = (FieldElement[])MathArrays.buildArray(this.field, nCols);
            col = 0;
            ** while (col < nCols)
        }
lbl-1000:
        // 1 sources

        {
            sum = (FieldElement)this.field.getZero();
            i = 0;
            while (i < nRows) {
                sum = sum.add((FieldElement)this.getEntry(i, col).multiply(v.getEntry(i)));
                ++i;
            }
            out[col] = sum;
            ++col;
            continue;
        }
lbl20:
        // 1 sources

        return new ArrayFieldVector(this.field, out, false);
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int row = 0;
        while (row < rows) {
            int column = 0;
            while (column < columns) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInRowOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int row = startRow;
        while (row <= endRow) {
            int column = startColumn;
            while (column <= endColumn) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++column;
            }
            ++row;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor) {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        int column = 0;
        while (column < columns) {
            int row = 0;
            while (row < rows) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                T oldValue = this.getEntry(row, column);
                T newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInColumnOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkSubMatrixIndex(startRow, endRow, startColumn, endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        int column = startColumn;
        while (column <= endColumn) {
            int row = startRow;
            while (row <= endRow) {
                visitor.visit(row, column, this.getEntry(row, column));
                ++row;
            }
            ++column;
        }
        return visitor.end();
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor) {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor) {
        return this.walkInRowOrder(visitor);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixChangingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Override
    public T walkInOptimizedOrder(FieldMatrixPreservingVisitor<T> visitor, int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuffer res = new StringBuffer();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        int i = 0;
        while (i < nRows) {
            if (i > 0) {
                res.append(",");
            }
            res.append("{");
            int j = 0;
            while (j < nCols) {
                if (j > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i, j));
                ++j;
            }
            res.append("}");
            ++i;
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FieldMatrix)) {
            return false;
        }
        FieldMatrix m = (FieldMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                if (!this.getEntry(row, col).equals(m.getEntry(row, col))) {
                    return false;
                }
                ++col;
            }
            ++row;
        }
        return true;
    }

    public int hashCode() {
        int ret = 322562;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        int row = 0;
        while (row < nRows) {
            int col = 0;
            while (col < nCols) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * this.getEntry(row, col).hashCode();
                ++col;
            }
            ++row;
        }
        return ret;
    }

    protected void checkRowIndex(int row) throws OutOfRangeException {
        if (row < 0 || row >= this.getRowDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.ROW_INDEX, (Number)row, 0, this.getRowDimension() - 1);
        }
    }

    protected void checkColumnIndex(int column) throws OutOfRangeException {
        if (column < 0 || column >= this.getColumnDimension()) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.COLUMN_INDEX, (Number)column, 0, this.getColumnDimension() - 1);
        }
    }

    protected void checkSubMatrixIndex(int startRow, int endRow, int startColumn, int endColumn) throws NumberIsTooSmallException, OutOfRangeException {
        this.checkRowIndex(startRow);
        this.checkRowIndex(endRow);
        if (endRow < startRow) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_ROW_AFTER_FINAL_ROW, (Number)endRow, startRow, true);
        }
        this.checkColumnIndex(startColumn);
        this.checkColumnIndex(endColumn);
        if (endColumn < startColumn) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INITIAL_COLUMN_AFTER_FINAL_COLUMN, (Number)endColumn, startColumn, true);
        }
    }

    protected void checkSubMatrixIndex(int[] selectedRows, int[] selectedColumns) throws NoDataException, NullArgumentException, OutOfRangeException {
        if (selectedRows == null || selectedColumns == null) {
            throw new NullArgumentException();
        }
        if (selectedRows.length == 0 || selectedColumns.length == 0) {
            throw new NoDataException();
        }
        int[] nArray = selectedRows;
        int n = selectedRows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            this.checkRowIndex(row);
            ++n2;
        }
        nArray = selectedColumns;
        n = selectedColumns.length;
        n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            this.checkColumnIndex(column);
            ++n2;
        }
    }

    protected void checkAdditionCompatible(FieldMatrix<T> m) throws MatrixDimensionMismatchException {
        if (this.getRowDimension() != m.getRowDimension() || this.getColumnDimension() != m.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(m.getRowDimension(), m.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkSubtractionCompatible(FieldMatrix<T> m) throws MatrixDimensionMismatchException {
        if (this.getRowDimension() != m.getRowDimension() || this.getColumnDimension() != m.getColumnDimension()) {
            throw new MatrixDimensionMismatchException(m.getRowDimension(), m.getColumnDimension(), this.getRowDimension(), this.getColumnDimension());
        }
    }

    protected void checkMultiplicationCompatible(FieldMatrix<T> m) throws DimensionMismatchException {
        if (this.getColumnDimension() != m.getRowDimension()) {
            throw new DimensionMismatchException(m.getRowDimension(), this.getColumnDimension());
        }
    }
}

