/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.differentiation;

import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;

public class GradientFunction
implements MultivariateVectorFunction {
    private final MultivariateDifferentiableFunction f;

    public GradientFunction(MultivariateDifferentiableFunction f) {
        this.f = f;
    }

    @Override
    public double[] value(double[] point) {
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        int i = 0;
        while (i < point.length) {
            dsX[i] = new DerivativeStructure(point.length, 1, i, point[i]);
            ++i;
        }
        DerivativeStructure dsY = this.f.value(dsX);
        double[] y = new double[point.length];
        int[] orders = new int[point.length];
        int i2 = 0;
        while (i2 < point.length) {
            orders[i2] = 1;
            y[i2] = dsY.getPartialDerivative(orders);
            orders[i2] = 0;
            ++i2;
        }
        return y;
    }
}

