/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.ui.preferences.dialog;

import java.util.List;
import org.eclipse.draw3d.camera.FirstPersonCamera;
import org.eclipse.draw3d.camera.RestrictedFirstPersonCamera;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.draw3d.graphics3d.Graphics3DType;
import org.eclipse.draw3d.ui.Draw3DUIPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class Draw3DPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public Draw3DPreferencePage() {
        super(1);
        this.setPreferenceStore(Draw3DUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("Draw3D general preferences");
    }

    public void createFieldEditors() {
        Graphics3DRegistry.resetDescriptors();
        List descr = Graphics3DRegistry.getRenderersForType((Graphics3DType)Graphics3DType.SCREEN);
        String[][] renderers = new String[descr.size()][2];
        int i = 0;
        while (i < descr.size()) {
            renderers[i][0] = ((Graphics3DDescriptor)descr.get(i)).getName();
            renderers[i][1] = ((Graphics3DDescriptor)descr.get(i)).getRendererID();
            ++i;
        }
        ComboFieldEditor rendererCombo = new ComboFieldEditor("defaultScreenRenderer", "Default screen renderer", renderers, this.getFieldEditorParent());
        this.addField((FieldEditor)rendererCombo);
        rendererCombo.setEnabled(false, this.getFieldEditorParent());
        String[][] cameraTypes = new String[][]{{"Default first person camera", FirstPersonCamera.class.getName()}, {"Restricted first person camera", RestrictedFirstPersonCamera.class.getName()}};
        this.addField((FieldEditor)new RadioGroupFieldEditor("lwsCameraType", "Camera type:", 1, cameraTypes, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ColorFieldEditor("lwsBackgroundColor", "Background color", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("lwsDrawCoordinateAxes", "Draw axes", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("lwsDebug", "Debug", this.getFieldEditorParent()));
        String[][] fontOptions = new String[][]{{"Editor setting", "editor"}, {"Always on (ignore editor setting)", "on"}, {"Always off (ignore editor setting)", "off"}};
        this.addField((FieldEditor)new ComboFieldEditor("lwsFontAntialias", "Font antialiasing", fontOptions, this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }
}

