/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerTransaction;

final class TinkerElementContainer<T extends TinkerElement> {
    private T element;
    private Object elementId;
    private boolean isDeleted = false;
    private final ThreadLocal<T> transactionUpdatedValue = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Boolean> isDeletedInTx = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<Boolean> isModifiedInTx = ThreadLocal.withInitial(() -> false);
    private final ThreadLocal<Boolean> isReadInTx = ThreadLocal.withInitial(() -> false);
    private final AtomicInteger usesInTransactions = new AtomicInteger(0);
    private final ReentrantLock lock = new ReentrantLock();

    public TinkerElementContainer(Object elementId) {
        this.elementId = elementId;
    }

    public T get() {
        if (this.isDeletedInTx.get().booleanValue()) {
            return null;
        }
        if (this.transactionUpdatedValue.get() != null) {
            return (T)((TinkerElement)this.transactionUpdatedValue.get());
        }
        if (this.isDeleted) {
            return null;
        }
        return this.element;
    }

    public T getWithClone(TinkerTransaction tx) {
        if (this.isDeletedInTx.get().booleanValue()) {
            return null;
        }
        if (this.transactionUpdatedValue.get() != null) {
            return (T)((TinkerElement)this.transactionUpdatedValue.get());
        }
        if (this.isDeleted || null == this.element) {
            return null;
        }
        TinkerElement cloned = (TinkerElement)((TinkerElement)this.element).clone();
        this.transactionUpdatedValue.set(cloned);
        if (!this.isReadInTx.get().booleanValue()) {
            this.isReadInTx.set(true);
            this.usesInTransactions.incrementAndGet();
            tx.markRead(this);
        }
        return (T)cloned;
    }

    public T getUnmodified() {
        return this.element;
    }

    public T getModified() {
        return (T)((TinkerElement)this.transactionUpdatedValue.get());
    }

    public Object getElementId() {
        return this.elementId;
    }

    public boolean isChanged() {
        return this.isDeletedInTx.get() != false || this.isModifiedInTx.get() != false && this.transactionUpdatedValue.get() != null;
    }

    public boolean isDeleted() {
        return this.isDeleted || this.isDeletedInTx.get() != false;
    }

    public void markDeleted(TinkerTransaction tx) {
        if (!this.isDeletedInTx.get().booleanValue()) {
            this.usesInTransactions.incrementAndGet();
            this.isDeletedInTx.set(true);
            tx.markChanged(this);
        }
    }

    public void touch(T transactionElement, TinkerTransaction tx) {
        if (this.transactionUpdatedValue.get() == transactionElement && this.isModifiedInTx.get().booleanValue()) {
            return;
        }
        this.setDraft(transactionElement, tx);
    }

    public void setDraft(T transactionElement, TinkerTransaction tx) {
        this.elementId = ((TinkerElement)transactionElement).id();
        if (!this.isModifiedInTx.get().booleanValue()) {
            this.usesInTransactions.incrementAndGet();
            this.isModifiedInTx.set(true);
        }
        this.transactionUpdatedValue.set(transactionElement);
        tx.markChanged(this);
    }

    public boolean updatedOutsideTransaction() {
        TinkerElement updatedValue = (TinkerElement)this.transactionUpdatedValue.get();
        return this.isDeleted || this.element != null && updatedValue != null && updatedValue.version() != ((TinkerElement)this.element).version();
    }

    public void commit(long txVersion) {
        this.updateUsesCount();
        if (this.isDeletedInTx.get().booleanValue()) {
            if (null != this.element) {
                ((TinkerElement)this.element).removed = true;
            }
            this.element = null;
            this.isDeleted = true;
        } else {
            this.element = (TinkerElement)this.transactionUpdatedValue.get();
            ((TinkerElement)this.element).currentVersion = txVersion;
        }
        this.reset();
    }

    public void rollback() {
        this.updateUsesCount();
        this.reset();
    }

    private void updateUsesCount() {
        if (this.isDeletedInTx.get().booleanValue()) {
            this.usesInTransactions.decrementAndGet();
        }
        if (this.isModifiedInTx.get().booleanValue()) {
            this.usesInTransactions.decrementAndGet();
        }
        if (this.isReadInTx.get().booleanValue()) {
            this.usesInTransactions.decrementAndGet();
        }
    }

    public boolean canBeRemoved() {
        return this.usesInTransactions.get() == 0 && (this.isDeleted || this.element == null);
    }

    public void reset() {
        this.transactionUpdatedValue.remove();
        this.isDeletedInTx.set(false);
        this.isModifiedInTx.set(false);
        this.isReadInTx.set(false);
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public void releaseLock() {
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }
}

