/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.quorum.auth;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.storm.shade.org.apache.zookeeper.server.auth.DigestLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslQuorumServerCallbackHandler
implements CallbackHandler {
    private static final String USER_PREFIX = "user_";
    private static final Logger LOG = LoggerFactory.getLogger(SaslQuorumServerCallbackHandler.class);
    private String userName;
    private final boolean isDigestAuthn;
    private final Map<String, String> credentials;
    private final Set<String> authzHosts;

    public SaslQuorumServerCallbackHandler(AppConfigurationEntry[] configurationEntries, Set<String> authzHosts) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        boolean isDigestAuthn = true;
        for (AppConfigurationEntry entry : configurationEntries) {
            if (entry.getLoginModuleName().equals(DigestLoginModule.class.getName())) {
                Map<String, ?> options = entry.getOptions();
                for (Map.Entry<String, ?> pair : options.entrySet()) {
                    String key = pair.getKey();
                    if (!key.startsWith(USER_PREFIX)) continue;
                    String userName = key.substring(USER_PREFIX.length());
                    credentials.put(userName, (String)pair.getValue());
                }
                continue;
            }
            isDigestAuthn = false;
        }
        this.isDigestAuthn = isDigestAuthn;
        if (isDigestAuthn) {
            this.credentials = Collections.unmodifiableMap(credentials);
            LOG.warn("Using DIGEST-MD5 for quorum authorization");
        } else {
            this.credentials = Collections.emptyMap();
        }
        this.authzHosts = authzHosts;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nc) {
        if (this.credentials.get(nc.getDefaultName()) == null) {
            LOG.warn("User '{}' not found in list of DIGEST-MD5 authenticateable users.", (Object)nc.getDefaultName());
            return;
        }
        nc.setName(nc.getDefaultName());
        this.userName = nc.getDefaultName();
    }

    private void handlePasswordCallback(PasswordCallback pc) {
        if (this.credentials.containsKey(this.userName)) {
            pc.setPassword(this.credentials.get(this.userName).toCharArray());
        } else {
            LOG.warn("No password found for user: {}", (Object)this.userName);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.debug("QuorumLearner supplied realm: {}", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String[] components;
        String authenticationID = ac.getAuthenticationID();
        String authorizationID = ac.getAuthorizationID();
        boolean authzFlag = false;
        authzFlag = authenticationID.equals(authorizationID);
        if (!this.isDigestAuthn && authzFlag && !(authzFlag = (components = authorizationID.split("[/@]")).length == 3 ? this.authzHosts.contains(components[1]) : false)) {
            LOG.error("SASL authorization completed, {} is not authorized to connect", (Object)authorizationID);
        }
        ac.setAuthorized(authzFlag);
        if (ac.isAuthorized()) {
            ac.setAuthorizedID(authorizationID);
            LOG.info("Successfully authenticated learner: authenticationID={};  authorizationID={}.", (Object)authenticationID, (Object)authorizationID);
        }
        LOG.debug("SASL authorization completed, authorized flag set to {}", (Object)ac.isAuthorized());
    }
}

