/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlyLatestExecutor<K> {
    private static final Logger LOG = LoggerFactory.getLogger(OnlyLatestExecutor.class);
    private final Executor exec;
    private final ConcurrentMap<K, Runnable> latest;

    public OnlyLatestExecutor(Executor exec) {
        this.exec = exec;
        this.latest = new ConcurrentHashMap<K, Runnable>();
    }

    public void execute(K key, Runnable r) {
        Runnable old = this.latest.put(key, r);
        if (old == null) {
            this.exec.execute(() -> {
                Runnable run = (Runnable)this.latest.remove(key);
                if (run != null) {
                    run.run();
                }
            });
        } else {
            LOG.debug("Replacing runnable for {} - {}", key, (Object)r);
        }
    }
}

