/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.jute;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.storm.shade.org.apache.jute.BinaryInputArchive;
import org.apache.storm.shade.org.apache.jute.InputArchive;
import org.apache.storm.shade.org.apache.jute.Record;

public class RecordReader {
    private static HashMap<String, Method> archiveFactory = new HashMap();
    private InputArchive archive;

    private static InputArchive createArchive(InputStream in, String format) {
        Method factory = archiveFactory.get(format);
        if (factory != null) {
            Object[] params = new Object[]{in};
            try {
                return (InputArchive)factory.invoke(null, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordReader(InputStream in, String format) {
        this.archive = RecordReader.createArchive(in, format);
    }

    public void read(Record r) throws IOException {
        r.deserialize(this.archive, "");
    }

    static {
        try {
            archiveFactory.put("binary", BinaryInputArchive.class.getDeclaredMethod("getArchive", InputStream.class));
        }
        catch (NoSuchMethodException | SecurityException ex) {
            ex.printStackTrace();
        }
    }
}

