/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import com.rabbitmq.client.impl.nio.NioHelper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslEngineHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslEngineHelper.class);

    public static boolean doHandshake(WritableByteChannel writeChannel, ReadableByteChannel readChannel, SSLEngine engine) throws IOException {
        ByteBuffer plainOut = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer plainIn = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer cipherOut = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        ByteBuffer cipherIn = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        LOGGER.debug("Starting TLS handshake");
        SSLEngineResult.HandshakeStatus handshakeStatus = engine.getHandshakeStatus();
        LOGGER.debug("Initial handshake status is {}", (Object)handshakeStatus);
        block7: while (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            LOGGER.debug("Handshake status is {}", (Object)handshakeStatus);
            switch (handshakeStatus) {
                case NEED_TASK: {
                    LOGGER.debug("Running tasks");
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(engine);
                    continue block7;
                }
                case NEED_UNWRAP: {
                    LOGGER.debug("Unwrapping...");
                    handshakeStatus = SslEngineHelper.unwrap(cipherIn, plainIn, readChannel, engine);
                    continue block7;
                }
                case NEED_WRAP: {
                    LOGGER.debug("Wrapping...");
                    handshakeStatus = SslEngineHelper.wrap(plainOut, cipherOut, writeChannel, engine);
                    continue block7;
                }
                case FINISHED: {
                    continue block7;
                }
                case NOT_HANDSHAKING: {
                    continue block7;
                }
            }
            throw new SSLException("Unexpected handshake status " + (Object)((Object)handshakeStatus));
        }
        LOGGER.debug("TLS handshake completed");
        return true;
    }

    private static SSLEngineResult.HandshakeStatus runDelegatedTasks(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            LOGGER.debug("Running delegated task");
            runnable.run();
        }
        return sslEngine.getHandshakeStatus();
    }

    private static SSLEngineResult.HandshakeStatus unwrap(ByteBuffer cipherIn, ByteBuffer plainIn, ReadableByteChannel channel, SSLEngine sslEngine) throws IOException {
        SSLEngineResult unwrapResult;
        int read;
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        LOGGER.debug("Handshake status is {} before unwrapping", (Object)handshakeStatus);
        LOGGER.debug("Cipher in position {}", (Object)cipherIn.position());
        if (cipherIn.position() == 0) {
            LOGGER.debug("Reading from channel");
            read = channel.read(cipherIn);
            LOGGER.debug("Read {} byte(s) from channel", (Object)read);
            if (read < 0) {
                throw new SSLException("Could not read from socket channel");
            }
            cipherIn.flip();
        } else {
            LOGGER.debug("Not reading");
        }
        do {
            int positionBeforeUnwrapping = cipherIn.position();
            LOGGER.debug("Before unwrapping cipherIn is {}, with {} remaining byte(s)", (Object)cipherIn, (Object)cipherIn.remaining());
            unwrapResult = sslEngine.unwrap(cipherIn, plainIn);
            LOGGER.debug("SSL engine result is {} after unwrapping", (Object)unwrapResult);
            SSLEngineResult.Status status = unwrapResult.getStatus();
            switch (status) {
                case OK: {
                    plainIn.clear();
                    if (unwrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        handshakeStatus = SslEngineHelper.runDelegatedTasks(sslEngine);
                        cipherIn.position(positionBeforeUnwrapping + unwrapResult.bytesConsumed());
                        break;
                    }
                    handshakeStatus = unwrapResult.getHandshakeStatus();
                    break;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow during handshake");
                }
                case BUFFER_UNDERFLOW: {
                    LOGGER.debug("Buffer underflow");
                    cipherIn.compact();
                    LOGGER.debug("Reading from channel...");
                    read = NioHelper.read(channel, cipherIn);
                    if (read <= 0) {
                        SslEngineHelper.retryRead(channel, cipherIn);
                    }
                    LOGGER.debug("Done reading from channel...");
                    cipherIn.flip();
                    break;
                }
                case CLOSED: {
                    sslEngine.closeInbound();
                    break;
                }
                default: {
                    throw new SSLException("Unexpected status from " + unwrapResult);
                }
            }
        } while (unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP && unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED);
        LOGGER.debug("cipherIn position after unwrap {}", (Object)cipherIn.position());
        return handshakeStatus;
    }

    private static int retryRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int read = 0;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            read = NioHelper.read(channel, buffer);
            if (read > 0) break;
        }
        return read;
    }

    private static SSLEngineResult.HandshakeStatus wrap(ByteBuffer plainOut, ByteBuffer cipherOut, WritableByteChannel channel, SSLEngine sslEngine) throws IOException {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        LOGGER.debug("Handshake status is {} before wrapping", (Object)handshakeStatus);
        SSLEngineResult result = sslEngine.wrap(plainOut, cipherOut);
        LOGGER.debug("SSL engine result is {} after wrapping", (Object)result);
        switch (result.getStatus()) {
            case OK: {
                cipherOut.flip();
                while (cipherOut.hasRemaining()) {
                    int written = channel.write(cipherOut);
                    LOGGER.debug("Wrote {} byte(s)", (Object)written);
                }
                cipherOut.clear();
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    handshakeStatus = SslEngineHelper.runDelegatedTasks(sslEngine);
                    break;
                }
                handshakeStatus = result.getHandshakeStatus();
                break;
            }
            case BUFFER_OVERFLOW: {
                throw new SSLException("Buffer overflow during handshake");
            }
            default: {
                throw new SSLException("Unexpected status " + (Object)((Object)result.getStatus()));
            }
        }
        return handshakeStatus;
    }

    public static void write(WritableByteChannel socketChannel, SSLEngine engine, ByteBuffer plainOut, ByteBuffer cypherOut) throws IOException {
        block6: while (plainOut.hasRemaining()) {
            cypherOut.clear();
            SSLEngineResult result = engine.wrap(plainOut, cypherOut);
            switch (result.getStatus()) {
                case OK: {
                    cypherOut.flip();
                    while (cypherOut.hasRemaining()) {
                        socketChannel.write(cypherOut);
                    }
                    continue block6;
                }
                case BUFFER_OVERFLOW: {
                    throw new SSLException("Buffer overflow occured after a wrap.");
                }
                case BUFFER_UNDERFLOW: {
                    throw new SSLException("Buffer underflow occured after a wrap.");
                }
                case CLOSED: {
                    throw new SSLException("Buffer closed");
                }
            }
            throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
        }
    }

    public static void close(WritableByteChannel channel, SSLEngine engine) throws IOException {
        ByteBuffer plainOut = ByteBuffer.allocate(engine.getSession().getApplicationBufferSize());
        ByteBuffer cipherOut = ByteBuffer.allocate(engine.getSession().getPacketBufferSize());
        engine.closeOutbound();
        while (!engine.isOutboundDone()) {
            int num;
            engine.wrap(plainOut, cipherOut);
            cipherOut.flip();
            while (cipherOut.hasRemaining() && (num = channel.write(cipherOut)) != -1) {
            }
            cipherOut.clear();
        }
    }
}

