/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.hadoop.hbase.io.crypto.tls.HBaseHostnameVerifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseTrustManager
extends X509ExtendedTrustManager {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseTrustManager.class);
    private final X509ExtendedTrustManager x509ExtendedTrustManager;
    private final boolean hostnameVerificationEnabled;
    private final boolean allowReverseDnsLookup;
    private final HBaseHostnameVerifier hostnameVerifier;

    HBaseTrustManager(X509ExtendedTrustManager x509ExtendedTrustManager, boolean hostnameVerificationEnabled, boolean allowReverseDnsLookup) {
        this.x509ExtendedTrustManager = x509ExtendedTrustManager;
        this.hostnameVerificationEnabled = hostnameVerificationEnabled;
        this.allowReverseDnsLookup = allowReverseDnsLookup;
        this.hostnameVerifier = new HBaseHostnameVerifier();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.x509ExtendedTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType, socket);
        if (this.hostnameVerificationEnabled) {
            this.performHostVerification(socket.getInetAddress(), chain[0]);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType, socket);
        if (this.hostnameVerificationEnabled) {
            this.performHostVerification(socket.getInetAddress(), chain[0]);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType, engine);
        if (this.hostnameVerificationEnabled && engine != null) {
            try {
                if (engine.getPeerHost() == null) {
                    LOG.warn("Cannot perform client hostname verification, because peer information is not available");
                    return;
                }
                this.performHostVerification(InetAddress.getByName(engine.getPeerHost()), chain[0]);
            }
            catch (UnknownHostException e) {
                throw new CertificateException("Failed to verify host", e);
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType, engine);
        if (this.hostnameVerificationEnabled) {
            try {
                this.performHostVerification(InetAddress.getByName(engine.getPeerHost()), chain[0]);
            }
            catch (UnknownHostException e) {
                throw new CertificateException("Failed to verify host", e);
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509ExtendedTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.x509ExtendedTrustManager.checkServerTrusted(chain, authType);
    }

    private void performHostVerification(InetAddress inetAddress, X509Certificate certificate) throws CertificateException {
        String hostAddress = "";
        String hostName = "";
        try {
            hostAddress = inetAddress.getHostAddress();
            this.hostnameVerifier.verify(hostAddress, certificate);
        }
        catch (SSLException addressVerificationException) {
            String inetAddressString = inetAddress.toString();
            if (!inetAddressString.startsWith("/")) {
                LOG.debug("Failed to verify host address: {}, but inetAddress {} has a hostname, trying that", new Object[]{hostAddress, inetAddressString, addressVerificationException});
            } else if (this.allowReverseDnsLookup) {
                LOG.debug("Failed to verify host address: {}, attempting to verify host name with reverse dns", (Object)hostAddress, (Object)addressVerificationException);
            } else {
                LOG.debug("Failed to verify host address: {}, but reverse dns lookup is disabled", (Object)hostAddress, (Object)addressVerificationException);
                throw new CertificateException("Failed to verify host address, and reverse lookup is disabled", addressVerificationException);
            }
            try {
                hostName = inetAddress.getHostName();
                this.hostnameVerifier.verify(hostName, certificate);
            }
            catch (SSLException hostnameVerificationException) {
                LOG.error("Failed to verify host address: {}", (Object)hostAddress, (Object)addressVerificationException);
                LOG.error("Failed to verify hostname: {}", (Object)hostName, (Object)hostnameVerificationException);
                throw new CertificateException("Failed to verify both host address and host name", hostnameVerificationException);
            }
        }
    }
}

