/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class SizeCachedKeyValue
extends KeyValue {
    private static final int FIXED_OVERHEAD = 6;
    private short rowLen;
    private int keyLen;

    public SizeCachedKeyValue(byte[] bytes, int offset, int length, long seqId, int keyLen) {
        super(bytes, offset, length);
        this.rowLen = super.getRowLength();
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    public SizeCachedKeyValue(byte[] bytes, int offset, int length, long seqId, int keyLen, short rowLen) {
        super(bytes, offset, length);
        this.rowLen = rowLen;
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    @Override
    public short getRowLength() {
        return this.rowLen;
    }

    @Override
    public int getKeyLength() {
        return this.keyLen;
    }

    @Override
    public long heapSize() {
        return super.heapSize() + 6L;
    }

    @Override
    public int getSerializedSize() {
        return this.length;
    }
}

