/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import java.util.List;
import java.util.Map;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.utils.ListDelegate;

public class KryoValuesSerializer {
    Kryo kryo;
    ListDelegate delegate;
    Output kryoOut;

    public KryoValuesSerializer(Map<String, Object> conf) {
        this.kryo = SerializationFactory.getKryo(conf);
        this.delegate = new ListDelegate();
        this.kryoOut = new Output(2000, 2000000000);
    }

    public void serializeInto(List<Object> values, Output out) {
        this.delegate.setDelegate(values);
        this.kryo.writeObject(out, (Object)this.delegate);
    }

    public byte[] serialize(List<Object> values) {
        this.kryoOut.reset();
        this.serializeInto(values, this.kryoOut);
        return this.kryoOut.toBytes();
    }

    public byte[] serializeObject(Object obj) {
        this.kryoOut.reset();
        this.kryo.writeClassAndObject(this.kryoOut, obj);
        return this.kryoOut.toBytes();
    }
}

