/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.storm.Thrift;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.grouping.LoadAwareCustomStreamGrouping;
import org.apache.storm.grouping.LoadAwareShuffleGrouping;
import org.apache.storm.grouping.LoadMapping;
import org.apache.storm.grouping.ShuffleGrouping;
import org.apache.storm.shade.com.google.common.collect.Ordering;
import org.apache.storm.shade.com.google.common.collect.Sets;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.TupleUtils;
import org.apache.storm.utils.Utils;

public class GrouperFactory {
    public static final LoadAwareCustomStreamGrouping DIRECT = new LoadAwareCustomStreamGrouping(){

        @Override
        public void refreshLoad(LoadMapping loadMapping) {
        }

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            return null;
        }
    };

    public static LoadAwareCustomStreamGrouping mkGrouper(WorkerTopologyContext context, String componentId, String streamId, Fields outFields, Grouping thriftGrouping, List<Integer> unsortedTargetTasks, Map<String, Object> topoConf) {
        List targetTasks = Ordering.natural().sortedCopy(unsortedTargetTasks);
        boolean isNotLoadAware = null != topoConf.get("topology.disable.loadaware.messaging") && (Boolean)topoConf.get("topology.disable.loadaware.messaging") != false;
        CustomStreamGrouping result2 = null;
        switch (Thrift.groupingType(thriftGrouping)) {
            case FIELDS: {
                if (Thrift.isGlobalGrouping(thriftGrouping)) {
                    result2 = new GlobalGrouper();
                    break;
                }
                result2 = new FieldsGrouper(outFields, thriftGrouping);
                break;
            }
            case SHUFFLE: {
                if (isNotLoadAware) {
                    result2 = new ShuffleGrouping();
                    break;
                }
                result2 = new LoadAwareShuffleGrouping();
                break;
            }
            case ALL: {
                result2 = new AllGrouper();
                break;
            }
            case LOCAL_OR_SHUFFLE: {
                Sets.SetView sameTasks = Sets.intersection((Set)Sets.newHashSet((Iterable)targetTasks), (Set)Sets.newHashSet(context.getThisWorkerTasks()));
                List list = targetTasks = sameTasks.isEmpty() ? targetTasks : new ArrayList(sameTasks);
                if (isNotLoadAware) {
                    result2 = new ShuffleGrouping();
                    break;
                }
                result2 = new LoadAwareShuffleGrouping();
                break;
            }
            case NONE: {
                result2 = new NoneGrouper();
                break;
            }
            case CUSTOM_OBJECT: {
                result2 = (CustomStreamGrouping)Thrift.instantiateJavaObject(thriftGrouping.get_custom_object());
                break;
            }
            case CUSTOM_SERIALIZED: {
                result2 = Utils.javaDeserialize(thriftGrouping.get_custom_serialized(), CustomStreamGrouping.class);
                break;
            }
            case DIRECT: {
                result2 = DIRECT;
                break;
            }
            default: {
                result2 = null;
            }
        }
        if (null != result2) {
            result2.prepare(context, new GlobalStreamId(componentId, streamId), targetTasks);
        }
        if (result2 instanceof LoadAwareCustomStreamGrouping) {
            return result2;
        }
        return new BasicLoadAwareCustomStreamGrouping(result2);
    }

    public static class GlobalGrouper
    implements CustomStreamGrouping {
        private List<Integer> targetTasks;

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
            this.targetTasks = targetTasks;
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            if (this.targetTasks.isEmpty()) {
                return null;
            }
            return Collections.singletonList(this.targetTasks.get(0));
        }
    }

    public static class FieldsGrouper
    implements CustomStreamGrouping {
        private Fields outFields;
        private List<List<Integer>> targetTasks;
        private Fields groupFields;
        private int numTasks;

        public FieldsGrouper(Fields outFields, Grouping thriftGrouping) {
            this.outFields = outFields;
            this.groupFields = new Fields(Thrift.fieldGrouping(thriftGrouping));
        }

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
            this.targetTasks = new ArrayList<List<Integer>>();
            for (Integer targetTask : targetTasks) {
                this.targetTasks.add(Collections.singletonList(targetTask));
            }
            this.numTasks = targetTasks.size();
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            int targetTaskIndex = TupleUtils.chooseTaskIndex(this.outFields.select(this.groupFields, values), this.numTasks);
            return this.targetTasks.get(targetTaskIndex);
        }
    }

    public static class AllGrouper
    implements CustomStreamGrouping {
        private List<Integer> targetTasks;

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
            this.targetTasks = targetTasks;
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            return this.targetTasks;
        }
    }

    public static class NoneGrouper
    implements CustomStreamGrouping {
        private final Random random = new Random();
        private List<Integer> targetTasks;
        private int numTasks;

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
            this.targetTasks = targetTasks;
            this.numTasks = targetTasks.size();
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            int index = this.random.nextInt(this.numTasks);
            return Collections.singletonList(this.targetTasks.get(index));
        }
    }

    public static class BasicLoadAwareCustomStreamGrouping
    implements LoadAwareCustomStreamGrouping {
        private final CustomStreamGrouping customStreamGrouping;

        public BasicLoadAwareCustomStreamGrouping(CustomStreamGrouping customStreamGrouping) {
            this.customStreamGrouping = customStreamGrouping;
        }

        @Override
        public void refreshLoad(LoadMapping loadMapping) {
        }

        @Override
        public void prepare(WorkerTopologyContext context, GlobalStreamId stream, List<Integer> targetTasks) {
            this.customStreamGrouping.prepare(context, stream, targetTasks);
        }

        @Override
        public List<Integer> chooseTasks(int taskId, List<Object> values) {
            return this.customStreamGrouping.chooseTasks(taskId, values);
        }
    }
}

