/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.graph;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.DirectedGraph;
import org.apache.storm.trident.graph.Group;
import org.apache.storm.trident.planner.Node;
import org.apache.storm.trident.util.IndexedEdge;

public class GraphGrouper {
    final DirectedGraph<Node, IndexedEdge> graph;
    final Set<Group> currGroups;
    final Map<Node, Group> groupIndex = new HashMap<Node, Group>();

    public GraphGrouper(DirectedGraph<Node, IndexedEdge> graph, Collection<Group> initialGroups) {
        this.graph = graph;
        this.currGroups = new LinkedHashSet<Group>(initialGroups);
        this.reindex();
    }

    public Collection<Group> getAllGroups() {
        return this.currGroups;
    }

    public void addGroup(Group g) {
        this.currGroups.add(g);
    }

    public void reindex() {
        this.groupIndex.clear();
        for (Group g : this.currGroups) {
            for (Node n : g.nodes) {
                this.groupIndex.put(n, g);
            }
        }
    }

    public void mergeFully() {
        boolean somethingHappened = true;
        block0: while (somethingHappened) {
            somethingHappened = false;
            for (Group g : this.currGroups) {
                Group in;
                Group out;
                Collection<Group> outgoingGroups = this.outgoingGroups(g);
                if (outgoingGroups.size() == 1 && (out = outgoingGroups.iterator().next()) != null) {
                    this.merge(g, out);
                    somethingHappened = true;
                    continue block0;
                }
                Collection<Group> incomingGroups = this.incomingGroups(g);
                if (incomingGroups.size() != 1 || (in = incomingGroups.iterator().next()) == null) continue;
                this.merge(g, in);
                somethingHappened = true;
                continue block0;
            }
        }
    }

    private void merge(Group g1, Group g2) {
        Group newGroup = new Group(g1, g2);
        this.currGroups.remove(g1);
        this.currGroups.remove(g2);
        this.currGroups.add(newGroup);
        for (Node n : newGroup.nodes) {
            this.groupIndex.put(n, newGroup);
        }
    }

    public Collection<Group> outgoingGroups(Group g) {
        HashSet<Group> ret = new HashSet<Group>();
        for (Node n : g.outgoingNodes()) {
            Group other = this.nodeGroup(n);
            if (other != null && other.equals(g)) continue;
            ret.add(other);
        }
        return ret;
    }

    public Collection<Group> incomingGroups(Group g) {
        HashSet<Group> ret = new HashSet<Group>();
        for (Node n : g.incomingNodes()) {
            Group other = this.nodeGroup(n);
            if (other != null && other.equals(g)) continue;
            ret.add(other);
        }
        return ret;
    }

    public Group nodeGroup(Node n) {
        return this.groupIndex.get(n);
    }
}

