/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.cgroup;

import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.util.Map;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.CpuCore;
import org.apache.storm.metrics2.WorkerMetricRegistrant;
import org.apache.storm.metrics2.cgroup.CGroupMetricsBase;
import org.apache.storm.task.TopologyContext;

public class CGroupCpuGuaranteeByCfsQuota
extends CGroupMetricsBase
implements WorkerMetricRegistrant {
    long guarantee = -1L;

    public CGroupCpuGuaranteeByCfsQuota(Map<String, Object> conf) {
        super(conf, SubSystemType.cpu);
    }

    @Override
    public void registerMetrics(TopologyContext topologyContext) {
        if (this.enabled) {
            topologyContext.registerGauge("CGroupCpuGuaranteeByCfsQuota", new Gauge<Long>(){

                public Long getValue() {
                    if (CGroupCpuGuaranteeByCfsQuota.this.guarantee < 0L) {
                        CpuCore cpu = (CpuCore)CGroupCpuGuaranteeByCfsQuota.this.core;
                        try {
                            long cpuCfsQuotaUs = cpu.getCpuCfsQuotaUs();
                            if (cpuCfsQuotaUs == -1L) {
                                CGroupCpuGuaranteeByCfsQuota.this.guarantee = -1L;
                            } else {
                                long cpuCfsPeriodUs = cpu.getCpuCfsPeriodUs();
                                CGroupCpuGuaranteeByCfsQuota.this.guarantee = cpuCfsQuotaUs * 100L / cpuCfsPeriodUs;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return CGroupCpuGuaranteeByCfsQuota.this.guarantee;
                }
            });
        }
    }
}

