/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit;

import org.apache.sling.testing.mock.osgi.context.ContextCallback;
import org.apache.sling.testing.mock.osgi.context.ContextPlugins;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.ExternalResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class OsgiContext
extends OsgiContextImpl
implements TestRule {
    private final ContextPlugins plugins;
    private final TestRule delegate;

    public OsgiContext() {
        this(new ContextPlugins());
    }

    public <T extends OsgiContextImpl> OsgiContext(@NotNull ContextCallback<T> afterSetUpCallback) {
        this(new ContextPlugins(afterSetUpCallback));
    }

    public <U extends OsgiContextImpl, V extends OsgiContextImpl> OsgiContext(@NotNull ContextCallback<U> afterSetUpCallback, @NotNull ContextCallback<V> beforeTearDownCallback) {
        this(new ContextPlugins(afterSetUpCallback, beforeTearDownCallback));
    }

    OsgiContext(@NotNull ContextPlugins contextPlugins) {
        this.plugins = contextPlugins;
        this.delegate = new ExternalResource(){

            protected void before() {
                OsgiContext.this.plugins.executeBeforeSetUpCallback((OsgiContextImpl)OsgiContext.this);
                OsgiContext.this.setUp();
                OsgiContext.this.plugins.executeAfterSetUpCallback((OsgiContextImpl)OsgiContext.this);
            }

            protected void after() {
                OsgiContext.this.plugins.executeBeforeTearDownCallback((OsgiContextImpl)OsgiContext.this);
                OsgiContext.this.tearDown();
                OsgiContext.this.plugins.executeAfterTearDownCallback((OsgiContextImpl)OsgiContext.this);
            }
        };
    }

    public Statement apply(Statement base, Description description) {
        return this.delegate.apply(base, description);
    }
}

