/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.serialization;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.VaultFile;
import org.apache.jackrabbit.vault.fs.api.VaultFileSystem;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.impl.aggregator.FileAggregator;
import org.apache.jackrabbit.vault.fs.impl.aggregator.GenericAggregator;
import org.apache.jackrabbit.vault.fs.impl.io.DocViewSerializer;
import org.apache.jackrabbit.vault.util.MimeTypes;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.ide.impl.vlt.VaultFsLocator;
import org.apache.sling.ide.jcr.RepositoryUtils;
import org.apache.sling.ide.log.Logger;
import org.apache.sling.ide.serialization.SerializationData;
import org.apache.sling.ide.serialization.SerializationDataBuilder;
import org.apache.sling.ide.serialization.SerializationException;
import org.apache.sling.ide.serialization.SerializationKind;
import org.apache.sling.ide.serialization.SerializationKindManager;
import org.apache.sling.ide.transport.RepositoryException;
import org.apache.sling.ide.transport.ResourceProxy;

public class VltSerializationDataBuilder
implements SerializationDataBuilder {
    private VaultFsLocator fsLocator;
    private SerializationKindManager skm;
    private org.apache.sling.ide.transport.Repository repo;
    private Session session;
    private VaultFileSystem fs;
    private Logger logger;

    public VltSerializationDataBuilder(Logger logger, VaultFsLocator fsLocator) {
        if (logger == null) {
            throw new RuntimeException("Logger is null");
        }
        if (fsLocator == null) {
            throw new RuntimeException("fsLocator is null");
        }
        this.logger = logger;
        this.fsLocator = fsLocator;
    }

    public void init(org.apache.sling.ide.transport.Repository repository, File contentSyncRoot) throws SerializationException {
        this.repo = repository;
        try {
            this.skm = new SerializationKindManager();
            this.skm.init(repository);
            if (!contentSyncRoot.exists()) {
                throw new IllegalArgumentException("contentSyncRoot does not exist: " + String.valueOf(contentSyncRoot));
            }
            Repository jcrRepo = RepositoryUtils.getRepository(this.repo.getRepositoryInfo());
            Credentials credentials = RepositoryUtils.getCredentials(this.repo.getRepositoryInfo());
            this.session = jcrRepo.login(credentials);
            RepositoryAddress address = RepositoryUtils.getRepositoryAddress(this.repo.getRepositoryInfo());
            this.fs = this.fsLocator.getFileSystem(address, contentSyncRoot, this.session);
        }
        catch (RepositoryException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void destroy() {
        if (this.session != null) {
            this.session.logout();
        }
    }

    public SerializationData buildSerializationData(File contentSyncRoot, ResourceProxy resource) throws SerializationException {
        try {
            List<Aggregate> chain = this.findAggregateChain(resource);
            if (chain == null) {
                return null;
            }
            Aggregate aggregate = chain.get(chain.size() - 1);
            String fileOrFolderPathHint = this.calculateFileOrFolderPathHint(chain);
            Object nameHint = PlatformNameFormat.getPlatformName(aggregate.getName());
            SerializationKind serializationKind = this.getSerializationKind(aggregate);
            if (resource.getPath().asString().equals("/") || serializationKind == SerializationKind.METADATA_PARTIAL || serializationKind == SerializationKind.FILE || serializationKind == SerializationKind.FOLDER) {
                nameHint = ".content.xml";
            } else if (serializationKind == SerializationKind.METADATA_FULL) {
                nameHint = (String)nameHint + ".xml";
            }
            this.logger.trace("Got location {0} for path {1}", new Object[]{fileOrFolderPathHint, resource.getPath()});
            if (!this.needsDir(aggregate)) {
                return SerializationData.empty((String)fileOrFolderPathHint, (SerializationKind)serializationKind);
            }
            DocViewSerializer s = new DocViewSerializer(aggregate);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            s.writeContent(out);
            byte[] result = out.toByteArray();
            return new SerializationData(fileOrFolderPathHint, (String)nameHint, result, serializationKind);
        }
        catch (javax.jcr.RepositoryException e) {
            throw new SerializationException((Throwable)e);
        }
        catch (IOException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    private SerializationKind getSerializationKind(Aggregate aggregate) throws javax.jcr.RepositoryException {
        NodeType[] mixinNodeTypes = aggregate.getNode().getMixinNodeTypes();
        ArrayList<String> mixinNodeTypeNames = new ArrayList<String>(mixinNodeTypes.length);
        for (NodeType nodeType : mixinNodeTypes) {
            mixinNodeTypeNames.add(nodeType.getName());
        }
        return this.skm.getSerializationKind(aggregate.getNode().getPrimaryNodeType().getName(), mixinNodeTypeNames);
    }

    private boolean needsDir(Aggregate aggregate) throws javax.jcr.RepositoryException, PathNotFoundException, ValueFormatException {
        Aggregator aggregator = this.fs.getAggregateManager().getAggregator(aggregate.getNode(), null);
        boolean needsDir = true;
        if (aggregator instanceof FileAggregator) {
            needsDir = false;
            Node content = aggregate.getNode();
            if (content.isNodeType("nt:file")) {
                content = content.getNode("jcr:content");
            }
            String mimeType = null;
            if (content.hasProperty("jcr:mimeType")) {
                try {
                    mimeType = content.getProperty("jcr:mimeType").getString();
                }
                catch (javax.jcr.RepositoryException repositoryException) {
                    // empty catch block
                }
            }
            if (mimeType == null) {
                mimeType = MimeTypes.getMimeType(aggregate.getNode().getName(), "application/octet-stream");
            }
            boolean bl = needsDir = !MimeTypes.matches(aggregate.getNode().getName(), mimeType, "application/octet-stream");
            if (!needsDir && content.hasProperty("jcr:mixinTypes")) {
                for (Value v : content.getProperty("jcr:mixinTypes").getValues()) {
                    if (v.getString().equals("mix:lockable")) continue;
                    needsDir = true;
                    break;
                }
            }
        } else if (aggregator instanceof GenericAggregator && this.isPlainNtFolder(aggregate)) {
            needsDir = false;
        }
        return needsDir;
    }

    private String calculateFileOrFolderPathHint(List<Aggregate> chain) throws javax.jcr.RepositoryException {
        ListIterator<Aggregate> aggs = chain.listIterator();
        StringBuilder out = new StringBuilder();
        while (aggs.hasNext()) {
            Aggregate cur = aggs.next();
            if (aggs.previousIndex() == 0) {
                out.append(PlatformNameFormat.getPlatformPath(cur.getPath()));
            } else {
                out.append("/");
                out.append(PlatformNameFormat.getPlatformPath(cur.getRelPath()));
            }
            if (!this.needsDir(cur)) continue;
            SerializationKind serializationKind = this.getSerializationKind(cur);
            if (serializationKind == SerializationKind.FILE) {
                out.append(".dir");
            }
            if (aggs.hasNext() || serializationKind != SerializationKind.METADATA_FULL) continue;
            out.delete(out.lastIndexOf("/"), out.length());
        }
        return out.toString();
    }

    private boolean isPlainNtFolder(Aggregate agg) throws javax.jcr.RepositoryException {
        return agg.getNode().getPrimaryNodeType().getName().equals("nt:folder") && agg.getNode().getMixinNodeTypes().length == 0;
    }

    private List<Aggregate> findAggregateChain(ResourceProxy resource) throws IOException, javax.jcr.RepositoryException {
        VaultFile vaultFile = this.fs.getFile(PlatformNameFormat.getPlatformPath(resource.getPath().asString()));
        if (vaultFile == null || vaultFile.getAggregate() == null) {
            String parentPath = resource.getPath().getParent().asString();
            while (!parentPath.equals("/")) {
                VaultFile parentFile = this.fs.getFile(PlatformNameFormat.getPlatformPath(parentPath));
                if (parentFile != null) {
                    Aggregate parentAggregate = parentFile.getAggregate();
                    ArrayList<Aggregate> parents = new ArrayList<Aggregate>();
                    parents.add(parentAggregate);
                    List<Aggregate> chain = this.lookForAggregateInLeaves(resource, parentAggregate, parents);
                    if (chain != null) {
                        return chain;
                    }
                }
                parentPath = Text.getRelativeParent(parentPath, 1);
            }
            return null;
        }
        return Collections.singletonList(vaultFile.getAggregate());
    }

    private List<Aggregate> lookForAggregateInLeaves(ResourceProxy resource, Aggregate parentAggregate, List<Aggregate> chain) throws javax.jcr.RepositoryException {
        if (parentAggregate == null) {
            return null;
        }
        List<? extends Aggregate> leaves = parentAggregate.getLeaves();
        if (leaves == null) {
            return null;
        }
        for (Aggregate aggregate : leaves) {
            if (aggregate.getPath().equals(resource.getPath().asString())) {
                chain.add(aggregate);
                return chain;
            }
            if (!Text.isDescendant(aggregate.getPath(), resource.getPath().asString())) continue;
            chain.add(aggregate);
            return this.lookForAggregateInLeaves(resource, aggregate, chain);
        }
        return null;
    }
}

