/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.archaius.sources;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.archaius.sources.ConfigModel;
import org.apache.servicecomb.config.archaius.sources.YAMLConfigLoader;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceConfigLoader
extends YAMLConfigLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceConfigLoader.class);
    private static final String ADDITIONAL_CONFIG_URL = "servicecomb.configurationSource.additionalUrls";
    private static final String DEFAULT_FILE_NAME = "servicecomb.configurationSource.defaultFileName";
    private static final String DEFAULT_CONFIG_FILE_NAME = "microservice.yaml";

    public MicroserviceConfigLoader() {
        if (!StringUtils.isEmpty((CharSequence)System.getProperty("cse.configurationSource.additionalUrls"))) {
            throw new IllegalArgumentException("-Dcse.configurationSource.additionalUrls has been replaced with -Dservicecomb.configurationSource.additionalUrls, please change it and restart.");
        }
        if (!StringUtils.isEmpty((CharSequence)System.getProperty("cse.configurationSource.defaultFileName"))) {
            throw new IllegalArgumentException("-Dcse.configurationSource.additionalUrls has been replaced with -Dservicecomb.configurationSource.defaultFileName, please change it and restart.");
        }
    }

    public void loadAndSort() {
        String configFileFromClasspath = null;
        try {
            configFileFromClasspath = System.getProperty(DEFAULT_FILE_NAME) == null ? DEFAULT_CONFIG_FILE_NAME : System.getProperty(DEFAULT_FILE_NAME);
            super.load(configFileFromClasspath);
            this.loadAdditionalConfig();
            if (this.configModels.isEmpty()) {
                LOGGER.warn("No URLs will be polled as dynamic configuration sources.");
                LOGGER.warn("To enable URLs as dynamic configuration sources, define System property {} or make {} available on classpath.", (Object)ADDITIONAL_CONFIG_URL, (Object)configFileFromClasspath);
            }
            this.sort();
        }
        catch (Exception e) {
            throw new ServiceCombException("Failed to load microservice configFile " + configFileFromClasspath, (Throwable)e);
        }
    }

    private void loadAdditionalConfig() throws IOException {
        String strUrls = System.getProperty(ADDITIONAL_CONFIG_URL);
        if (StringUtils.isEmpty((CharSequence)strUrls)) {
            return;
        }
        for (String strUrl : strUrls.split(",")) {
            URL url = new URL(strUrl);
            ConfigModel configModel = this.load(url);
            this.configModels.add(configModel);
        }
    }
}

