/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger;

import com.alibaba.fastjson.JSON;
import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.DLedgerRpcService;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.ShutdownAbleThread;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.protocol.HeartBeatRequest;
import io.openmessaging.storage.dledger.protocol.HeartBeatResponse;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferRequest;
import io.openmessaging.storage.dledger.protocol.LeadershipTransferResponse;
import io.openmessaging.storage.dledger.protocol.VoteRequest;
import io.openmessaging.storage.dledger.protocol.VoteResponse;
import io.openmessaging.storage.dledger.utils.DLedgerUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerLeaderElector {
    private static Logger logger = LoggerFactory.getLogger(DLedgerLeaderElector.class);
    private Random random = new Random();
    private DLedgerConfig dLedgerConfig;
    private final MemberState memberState;
    private DLedgerRpcService dLedgerRpcService;
    private volatile long lastLeaderHeartBeatTime = -1L;
    private volatile long lastSendHeartBeatTime = -1L;
    private volatile long lastSuccHeartBeatTime = -1L;
    private int heartBeatTimeIntervalMs = 2000;
    private int maxHeartBeatLeak = 3;
    private long nextTimeToRequestVote = -1L;
    private volatile boolean needIncreaseTermImmediately = false;
    private int minVoteIntervalMs = 300;
    private int maxVoteIntervalMs = 1000;
    private List<RoleChangeHandler> roleChangeHandlers = new ArrayList<RoleChangeHandler>();
    private VoteResponse.ParseResult lastParseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
    private long lastVoteCost = 0L;
    private StateMaintainer stateMaintainer = new StateMaintainer("StateMaintainer", logger);
    private final TakeLeadershipTask takeLeadershipTask = new TakeLeadershipTask();

    public DLedgerLeaderElector(DLedgerConfig dLedgerConfig, MemberState memberState, DLedgerRpcService dLedgerRpcService) {
        this.dLedgerConfig = dLedgerConfig;
        this.memberState = memberState;
        this.dLedgerRpcService = dLedgerRpcService;
        this.refreshIntervals(dLedgerConfig);
    }

    public void startup() {
        this.stateMaintainer.start();
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            roleChangeHandler.startup();
        }
    }

    public void shutdown() {
        this.stateMaintainer.shutdown();
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            roleChangeHandler.shutdown();
        }
    }

    private void refreshIntervals(DLedgerConfig dLedgerConfig) {
        this.heartBeatTimeIntervalMs = dLedgerConfig.getHeartBeatTimeIntervalMs();
        this.maxHeartBeatLeak = dLedgerConfig.getMaxHeartBeatLeak();
        this.minVoteIntervalMs = dLedgerConfig.getMinVoteIntervalMs();
        this.maxVoteIntervalMs = dLedgerConfig.getMaxVoteIntervalMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<HeartBeatResponse> handleHeartBeat(HeartBeatRequest request) throws Exception {
        if (!this.memberState.isPeerMember(request.getLeaderId())) {
            logger.warn("[BUG] [HandleHeartBeat] remoteId={} is an unknown member", (Object)request.getLeaderId());
            return CompletableFuture.completedFuture(new HeartBeatResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.UNKNOWN_MEMBER.getCode()));
        }
        if (this.memberState.getSelfId().equals(request.getLeaderId())) {
            logger.warn("[BUG] [HandleHeartBeat] selfId={} but remoteId={}", (Object)this.memberState.getSelfId(), (Object)request.getLeaderId());
            return CompletableFuture.completedFuture(new HeartBeatResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.UNEXPECTED_MEMBER.getCode()));
        }
        if (request.getTerm() < this.memberState.currTerm()) {
            return CompletableFuture.completedFuture(new HeartBeatResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.EXPIRED_TERM.getCode()));
        }
        if (request.getTerm() == this.memberState.currTerm() && request.getLeaderId().equals(this.memberState.getLeaderId())) {
            this.lastLeaderHeartBeatTime = System.currentTimeMillis();
            return CompletableFuture.completedFuture(new HeartBeatResponse());
        }
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (request.getTerm() < this.memberState.currTerm()) {
                return CompletableFuture.completedFuture(new HeartBeatResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.EXPIRED_TERM.getCode()));
            }
            if (request.getTerm() == this.memberState.currTerm()) {
                if (this.memberState.getLeaderId() == null) {
                    this.changeRoleToFollower(request.getTerm(), request.getLeaderId());
                    return CompletableFuture.completedFuture(new HeartBeatResponse());
                }
                if (request.getLeaderId().equals(this.memberState.getLeaderId())) {
                    this.lastLeaderHeartBeatTime = System.currentTimeMillis();
                    return CompletableFuture.completedFuture(new HeartBeatResponse());
                }
                logger.error("[{}][BUG] currTerm {} has leader {}, but received leader {}", new Object[]{this.memberState.getSelfId(), this.memberState.currTerm(), this.memberState.getLeaderId(), request.getLeaderId()});
                return CompletableFuture.completedFuture(new HeartBeatResponse().code(DLedgerResponseCode.INCONSISTENT_LEADER.getCode()));
            }
            this.changeRoleToCandidate(request.getTerm());
            this.needIncreaseTermImmediately = true;
            return CompletableFuture.completedFuture(new HeartBeatResponse().code(DLedgerResponseCode.TERM_NOT_READY.getCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRoleToLeader(long term) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (this.memberState.currTerm() == term) {
                this.memberState.changeToLeader(term);
                this.lastSendHeartBeatTime = -1L;
                this.handleRoleChange(term, MemberState.Role.LEADER);
                logger.info("[{}] [ChangeRoleToLeader] from term: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            } else {
                logger.warn("[{}] skip to be the leader in term: {}, but currTerm is: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRoleToCandidate(long term) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (term >= this.memberState.currTerm()) {
                this.memberState.changeToCandidate(term);
                this.handleRoleChange(term, MemberState.Role.CANDIDATE);
                logger.info("[{}] [ChangeRoleToCandidate] from term: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            } else {
                logger.info("[{}] skip to be candidate in term: {}, but currTerm: {}", new Object[]{this.memberState.getSelfId(), term, this.memberState.currTerm()});
            }
        }
    }

    public void testRevote(long term) {
        this.changeRoleToCandidate(term);
        this.lastParseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
        this.nextTimeToRequestVote = -1L;
    }

    public void changeRoleToFollower(long term, String leaderId) {
        logger.info("[{}][ChangeRoleToFollower] from term: {} leaderId: {} and currTerm: {}", new Object[]{this.memberState.getSelfId(), term, leaderId, this.memberState.currTerm()});
        this.lastParseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
        this.memberState.changeToFollower(term, leaderId);
        this.lastLeaderHeartBeatTime = System.currentTimeMillis();
        this.handleRoleChange(term, MemberState.Role.FOLLOWER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<VoteResponse> handleVote(VoteRequest request, boolean self) {
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (!this.memberState.isPeerMember(request.getLeaderId())) {
                logger.warn("[BUG] [HandleVote] remoteId={} is an unknown member", (Object)request.getLeaderId());
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_UNKNOWN_LEADER));
            }
            if (!self && this.memberState.getSelfId().equals(request.getLeaderId())) {
                logger.warn("[BUG] [HandleVote] selfId={} but remoteId={}", (Object)this.memberState.getSelfId(), (Object)request.getLeaderId());
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_UNEXPECTED_LEADER));
            }
            if (request.getLedgerEndTerm() < this.memberState.getLedgerEndTerm()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_EXPIRED_LEDGER_TERM));
            }
            if (request.getLedgerEndTerm() == this.memberState.getLedgerEndTerm() && request.getLedgerEndIndex() < this.memberState.getLedgerEndIndex()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_SMALL_LEDGER_END_INDEX));
            }
            if (request.getTerm() < this.memberState.currTerm()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_EXPIRED_VOTE_TERM));
            }
            if (request.getTerm() == this.memberState.currTerm()) {
                if (this.memberState.currVoteFor() != null && !this.memberState.currVoteFor().equals(request.getLeaderId())) {
                    if (this.memberState.getLeaderId() != null) {
                        return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_ALREADY_HAS_LEADER));
                    }
                    return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_ALREADY_VOTED));
                }
            } else {
                this.changeRoleToCandidate(request.getTerm());
                this.needIncreaseTermImmediately = true;
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_TERM_NOT_READY));
            }
            if (request.getTerm() < this.memberState.getLedgerEndTerm()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.getLedgerEndTerm()).voteResult(VoteResponse.RESULT.REJECT_TERM_SMALL_THAN_LEDGER));
            }
            if (!self && this.isTakingLeadership() && request.getLedgerEndTerm() == this.memberState.getLedgerEndTerm() && this.memberState.getLedgerEndIndex() >= request.getLedgerEndIndex()) {
                return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.REJECT_TAKING_LEADERSHIP));
            }
            this.memberState.setCurrVoteFor(request.getLeaderId());
            return CompletableFuture.completedFuture(new VoteResponse(request).term(this.memberState.currTerm()).voteResult(VoteResponse.RESULT.ACCEPT));
        }
    }

    private void sendHeartbeats(long term, String leaderId) throws Exception {
        AtomicInteger allNum = new AtomicInteger(1);
        AtomicInteger succNum = new AtomicInteger(1);
        AtomicInteger notReadyNum = new AtomicInteger(0);
        AtomicLong maxTerm = new AtomicLong(-1L);
        AtomicBoolean inconsistLeader = new AtomicBoolean(false);
        CountDownLatch beatLatch = new CountDownLatch(1);
        long startHeartbeatTimeMs = System.currentTimeMillis();
        for (String id : this.memberState.getPeerMap().keySet()) {
            if (this.memberState.getSelfId().equals(id)) continue;
            HeartBeatRequest heartBeatRequest = new HeartBeatRequest();
            heartBeatRequest.setGroup(this.memberState.getGroup());
            heartBeatRequest.setLocalId(this.memberState.getSelfId());
            heartBeatRequest.setRemoteId(id);
            heartBeatRequest.setLeaderId(leaderId);
            heartBeatRequest.setTerm(term);
            CompletableFuture<HeartBeatResponse> future = this.dLedgerRpcService.heartBeat(heartBeatRequest);
            future.whenComplete((x, ex) -> {
                try {
                    if (ex != null) {
                        this.memberState.getPeersLiveTable().put(id, Boolean.FALSE);
                        throw ex;
                    }
                    switch (DLedgerResponseCode.valueOf(x.getCode())) {
                        case SUCCESS: {
                            succNum.incrementAndGet();
                            break;
                        }
                        case EXPIRED_TERM: {
                            maxTerm.set(x.getTerm());
                            break;
                        }
                        case INCONSISTENT_LEADER: {
                            inconsistLeader.compareAndSet(false, true);
                            break;
                        }
                        case TERM_NOT_READY: {
                            notReadyNum.incrementAndGet();
                            break;
                        }
                    }
                    if (x.getCode() == DLedgerResponseCode.NETWORK_ERROR.getCode()) {
                        this.memberState.getPeersLiveTable().put(id, Boolean.FALSE);
                    } else {
                        this.memberState.getPeersLiveTable().put(id, Boolean.TRUE);
                    }
                    if (this.memberState.isQuorum(succNum.get()) || this.memberState.isQuorum(succNum.get() + notReadyNum.get())) {
                        beatLatch.countDown();
                    }
                }
                catch (Throwable t) {
                    logger.error("heartbeat response failed", t);
                }
                finally {
                    allNum.incrementAndGet();
                    if (allNum.get() == this.memberState.peerSize()) {
                        beatLatch.countDown();
                    }
                }
            });
        }
        beatLatch.await(this.heartBeatTimeIntervalMs, TimeUnit.MILLISECONDS);
        if (this.memberState.isQuorum(succNum.get())) {
            this.lastSuccHeartBeatTime = System.currentTimeMillis();
        } else {
            logger.info("[{}] Parse heartbeat responses in cost={} term={} allNum={} succNum={} notReadyNum={} inconsistLeader={} maxTerm={} peerSize={} lastSuccHeartBeatTime={}", new Object[]{this.memberState.getSelfId(), DLedgerUtils.elapsed(startHeartbeatTimeMs), term, allNum.get(), succNum.get(), notReadyNum.get(), inconsistLeader.get(), maxTerm.get(), this.memberState.peerSize(), new Timestamp(this.lastSuccHeartBeatTime)});
            if (this.memberState.isQuorum(succNum.get() + notReadyNum.get())) {
                this.lastSendHeartBeatTime = -1L;
            } else if (maxTerm.get() > term) {
                this.changeRoleToCandidate(maxTerm.get());
            } else if (inconsistLeader.get()) {
                this.changeRoleToCandidate(term);
            } else if (DLedgerUtils.elapsed(this.lastSuccHeartBeatTime) > (long)(this.maxHeartBeatLeak * this.heartBeatTimeIntervalMs)) {
                this.changeRoleToCandidate(term);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsLeader() throws Exception {
        if (DLedgerUtils.elapsed(this.lastSendHeartBeatTime) > (long)this.heartBeatTimeIntervalMs) {
            String leaderId;
            long term;
            MemberState memberState = this.memberState;
            synchronized (memberState) {
                if (!this.memberState.isLeader()) {
                    return;
                }
                term = this.memberState.currTerm();
                leaderId = this.memberState.getLeaderId();
                this.lastSendHeartBeatTime = System.currentTimeMillis();
            }
            this.sendHeartbeats(term, leaderId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsFollower() {
        if (DLedgerUtils.elapsed(this.lastLeaderHeartBeatTime) > (long)(2 * this.heartBeatTimeIntervalMs)) {
            MemberState memberState = this.memberState;
            synchronized (memberState) {
                if (this.memberState.isFollower() && DLedgerUtils.elapsed(this.lastLeaderHeartBeatTime) > (long)(this.maxHeartBeatLeak * this.heartBeatTimeIntervalMs)) {
                    logger.info("[{}][HeartBeatTimeOut] lastLeaderHeartBeatTime: {} heartBeatTimeIntervalMs: {} lastLeader={}", new Object[]{this.memberState.getSelfId(), new Timestamp(this.lastLeaderHeartBeatTime), this.heartBeatTimeIntervalMs, this.memberState.getLeaderId()});
                    this.changeRoleToCandidate(this.memberState.currTerm());
                }
            }
        }
    }

    private List<CompletableFuture<VoteResponse>> voteForQuorumResponses(long term, long ledgerEndTerm, long ledgerEndIndex) throws Exception {
        ArrayList<CompletableFuture<VoteResponse>> responses = new ArrayList<CompletableFuture<VoteResponse>>();
        for (String id : this.memberState.getPeerMap().keySet()) {
            VoteRequest voteRequest = new VoteRequest();
            voteRequest.setGroup(this.memberState.getGroup());
            voteRequest.setLedgerEndIndex(ledgerEndIndex);
            voteRequest.setLedgerEndTerm(ledgerEndTerm);
            voteRequest.setLeaderId(this.memberState.getSelfId());
            voteRequest.setTerm(term);
            voteRequest.setRemoteId(id);
            CompletableFuture<VoteResponse> voteResponse = this.memberState.getSelfId().equals(id) ? this.handleVote(voteRequest, true) : this.dLedgerRpcService.vote(voteRequest);
            responses.add(voteResponse);
        }
        return responses;
    }

    private boolean isTakingLeadership() {
        if (this.dLedgerConfig.getPreferredLeaderIds() != null && this.memberState.getTermToTakeLeadership() == this.memberState.currTerm()) {
            List<String> preferredLeaderIds = Arrays.asList(this.dLedgerConfig.getPreferredLeaderIds().split(";"));
            return preferredLeaderIds.contains(this.memberState.getSelfId());
        }
        return false;
    }

    private long getNextTimeToRequestVote() {
        if (this.isTakingLeadership()) {
            return System.currentTimeMillis() + (long)this.dLedgerConfig.getMinTakeLeadershipVoteIntervalMs() + (long)this.random.nextInt(this.dLedgerConfig.getMaxTakeLeadershipVoteIntervalMs() - this.dLedgerConfig.getMinTakeLeadershipVoteIntervalMs());
        }
        return System.currentTimeMillis() + (long)this.minVoteIntervalMs + (long)this.random.nextInt(this.maxVoteIntervalMs - this.minVoteIntervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maintainAsCandidate() throws Exception {
        VoteResponse.ParseResult parseResult;
        long ledgerEndTerm;
        long ledgerEndIndex;
        long term;
        if (System.currentTimeMillis() < this.nextTimeToRequestVote && !this.needIncreaseTermImmediately) {
            return;
        }
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (!this.memberState.isCandidate()) {
                return;
            }
            if (this.lastParseResult == VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT || this.needIncreaseTermImmediately) {
                long prevTerm = this.memberState.currTerm();
                term = this.memberState.nextTerm();
                logger.info("{}_[INCREASE_TERM] from {} to {}", new Object[]{this.memberState.getSelfId(), prevTerm, term});
                this.lastParseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            } else {
                term = this.memberState.currTerm();
            }
            ledgerEndIndex = this.memberState.getLedgerEndIndex();
            ledgerEndTerm = this.memberState.getLedgerEndTerm();
        }
        if (this.needIncreaseTermImmediately) {
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
            this.needIncreaseTermImmediately = false;
            return;
        }
        long startVoteTimeMs = System.currentTimeMillis();
        List<CompletableFuture<VoteResponse>> quorumVoteResponses = this.voteForQuorumResponses(term, ledgerEndTerm, ledgerEndIndex);
        AtomicLong knownMaxTermInGroup = new AtomicLong(term);
        AtomicInteger allNum = new AtomicInteger(0);
        AtomicInteger validNum = new AtomicInteger(0);
        AtomicInteger acceptedNum = new AtomicInteger(0);
        AtomicInteger notReadyTermNum = new AtomicInteger(0);
        AtomicInteger biggerLedgerNum = new AtomicInteger(0);
        AtomicBoolean alreadyHasLeader = new AtomicBoolean(false);
        CountDownLatch voteLatch = new CountDownLatch(1);
        for (CompletableFuture<VoteResponse> future : quorumVoteResponses) {
            future.whenComplete((x, ex) -> {
                try {
                    if (ex != null) {
                        throw ex;
                    }
                    logger.info("[{}][GetVoteResponse] {}", (Object)this.memberState.getSelfId(), (Object)JSON.toJSONString((Object)x));
                    if (x.getVoteResult() != VoteResponse.RESULT.UNKNOWN) {
                        validNum.incrementAndGet();
                    }
                    AtomicLong atomicLong = knownMaxTermInGroup;
                    synchronized (atomicLong) {
                        switch (x.getVoteResult()) {
                            case ACCEPT: {
                                acceptedNum.incrementAndGet();
                                break;
                            }
                            case REJECT_ALREADY_VOTED: 
                            case REJECT_TAKING_LEADERSHIP: {
                                break;
                            }
                            case REJECT_ALREADY_HAS_LEADER: {
                                alreadyHasLeader.compareAndSet(false, true);
                                break;
                            }
                            case REJECT_TERM_SMALL_THAN_LEDGER: 
                            case REJECT_EXPIRED_VOTE_TERM: {
                                if (x.getTerm() <= knownMaxTermInGroup.get()) break;
                                knownMaxTermInGroup.set(x.getTerm());
                                break;
                            }
                            case REJECT_EXPIRED_LEDGER_TERM: 
                            case REJECT_SMALL_LEDGER_END_INDEX: {
                                biggerLedgerNum.incrementAndGet();
                                break;
                            }
                            case REJECT_TERM_NOT_READY: {
                                notReadyTermNum.incrementAndGet();
                                break;
                            }
                        }
                    }
                    if (alreadyHasLeader.get() || this.memberState.isQuorum(acceptedNum.get()) || this.memberState.isQuorum(acceptedNum.get() + notReadyTermNum.get())) {
                        voteLatch.countDown();
                    }
                }
                catch (Throwable t) {
                    logger.error("vote response failed", t);
                }
                finally {
                    allNum.incrementAndGet();
                    if (allNum.get() == this.memberState.peerSize()) {
                        voteLatch.countDown();
                    }
                }
            });
        }
        try {
            voteLatch.await(2000 + this.random.nextInt(this.maxVoteIntervalMs), TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.lastVoteCost = DLedgerUtils.elapsed(startVoteTimeMs);
        if (knownMaxTermInGroup.get() > term) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
            this.changeRoleToCandidate(knownMaxTermInGroup.get());
        } else if (alreadyHasLeader.get()) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote() + (long)(this.heartBeatTimeIntervalMs * this.maxHeartBeatLeak);
        } else if (!this.memberState.isQuorum(validNum.get())) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
        } else if (!this.memberState.isQuorum(validNum.get() - biggerLedgerNum.get())) {
            parseResult = VoteResponse.ParseResult.WAIT_TO_REVOTE;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote() + (long)this.maxVoteIntervalMs;
        } else if (this.memberState.isQuorum(acceptedNum.get())) {
            parseResult = VoteResponse.ParseResult.PASSED;
        } else if (this.memberState.isQuorum(acceptedNum.get() + notReadyTermNum.get())) {
            parseResult = VoteResponse.ParseResult.REVOTE_IMMEDIATELY;
        } else {
            parseResult = VoteResponse.ParseResult.WAIT_TO_VOTE_NEXT;
            this.nextTimeToRequestVote = this.getNextTimeToRequestVote();
        }
        this.lastParseResult = parseResult;
        logger.info("[{}] [PARSE_VOTE_RESULT] cost={} term={} memberNum={} allNum={} acceptedNum={} notReadyTermNum={} biggerLedgerNum={} alreadyHasLeader={} maxTerm={} result={}", new Object[]{this.memberState.getSelfId(), this.lastVoteCost, term, this.memberState.peerSize(), allNum, acceptedNum, notReadyTermNum, biggerLedgerNum, alreadyHasLeader, knownMaxTermInGroup.get(), parseResult});
        if (parseResult == VoteResponse.ParseResult.PASSED) {
            logger.info("[{}] [VOTE_RESULT] has been elected to be the leader in term {}", (Object)this.memberState.getSelfId(), (Object)term);
            this.changeRoleToLeader(term);
        }
    }

    private void maintainState() throws Exception {
        if (this.memberState.isLeader()) {
            this.maintainAsLeader();
        } else if (this.memberState.isFollower()) {
            this.maintainAsFollower();
        } else {
            this.maintainAsCandidate();
        }
    }

    private void handleRoleChange(long term, MemberState.Role role) {
        try {
            this.takeLeadershipTask.check(term, role);
        }
        catch (Throwable t) {
            logger.error("takeLeadershipTask.check failed. ter={}, role={}", new Object[]{term, role, t});
        }
        for (RoleChangeHandler roleChangeHandler : this.roleChangeHandlers) {
            try {
                roleChangeHandler.handle(term, role);
            }
            catch (Throwable t) {
                logger.warn("Handle role change failed term={} role={} handler={}", new Object[]{term, role, roleChangeHandler.getClass(), t});
            }
        }
    }

    public void addRoleChangeHandler(RoleChangeHandler roleChangeHandler) {
        if (!this.roleChangeHandlers.contains(roleChangeHandler)) {
            this.roleChangeHandlers.add(roleChangeHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LeadershipTransferResponse> handleLeadershipTransfer(LeadershipTransferRequest request) throws Exception {
        logger.info("handleLeadershipTransfer: {}", (Object)request);
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (this.memberState.currTerm() != request.getTerm()) {
                logger.warn("[BUG] [HandleLeaderTransfer] currTerm={} != request.term={}", (Object)this.memberState.currTerm(), (Object)request.getTerm());
                return CompletableFuture.completedFuture(new LeadershipTransferResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.INCONSISTENT_TERM.getCode()));
            }
            if (!this.memberState.isLeader()) {
                logger.warn("[BUG] [HandleLeaderTransfer] selfId={} is not leader", (Object)request.getLeaderId());
                return CompletableFuture.completedFuture(new LeadershipTransferResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.NOT_LEADER.getCode()));
            }
            if (this.memberState.getTransferee() != null) {
                logger.warn("[BUG] [HandleLeaderTransfer] transferee={} is already set", (Object)this.memberState.getTransferee());
                return CompletableFuture.completedFuture(new LeadershipTransferResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.LEADER_TRANSFERRING.getCode()));
            }
            this.memberState.setTransferee(request.getTransfereeId());
        }
        LeadershipTransferRequest takeLeadershipRequest = new LeadershipTransferRequest();
        takeLeadershipRequest.setGroup(this.memberState.getGroup());
        takeLeadershipRequest.setLeaderId(this.memberState.getLeaderId());
        takeLeadershipRequest.setLocalId(this.memberState.getSelfId());
        takeLeadershipRequest.setRemoteId(request.getTransfereeId());
        takeLeadershipRequest.setTerm(request.getTerm());
        takeLeadershipRequest.setTakeLeadershipLedgerIndex(this.memberState.getLedgerEndIndex());
        takeLeadershipRequest.setTransferId(this.memberState.getSelfId());
        takeLeadershipRequest.setTransfereeId(request.getTransfereeId());
        if (this.memberState.currTerm() != request.getTerm()) {
            logger.warn("[HandleLeaderTransfer] term changed, cur={} , request={}", (Object)this.memberState.currTerm(), (Object)request.getTerm());
            return CompletableFuture.completedFuture(new LeadershipTransferResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.EXPIRED_TERM.getCode()));
        }
        return this.dLedgerRpcService.leadershipTransfer(takeLeadershipRequest).thenApply(response -> {
            MemberState memberState = this.memberState;
            synchronized (memberState) {
                if (response.getCode() != DLedgerResponseCode.SUCCESS.getCode() || this.memberState.currTerm() == request.getTerm() && this.memberState.getTransferee() != null) {
                    logger.warn("leadershipTransfer failed, set transferee to null");
                    this.memberState.setTransferee(null);
                }
            }
            return response;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LeadershipTransferResponse> handleTakeLeadership(LeadershipTransferRequest request) throws Exception {
        logger.debug("handleTakeLeadership.request={}", (Object)request);
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            if (this.memberState.currTerm() != request.getTerm()) {
                logger.warn("[BUG] [handleTakeLeadership] currTerm={} != request.term={}", (Object)this.memberState.currTerm(), (Object)request.getTerm());
                return CompletableFuture.completedFuture(new LeadershipTransferResponse().term(this.memberState.currTerm()).code(DLedgerResponseCode.INCONSISTENT_TERM.getCode()));
            }
            long targetTerm = request.getTerm() + 1L;
            this.memberState.setTermToTakeLeadership(targetTerm);
            CompletableFuture<LeadershipTransferResponse> response = new CompletableFuture<LeadershipTransferResponse>();
            this.takeLeadershipTask.update(request, response);
            this.changeRoleToCandidate(targetTerm);
            this.needIncreaseTermImmediately = true;
            return response;
        }
    }

    public class StateMaintainer
    extends ShutdownAbleThread {
        public StateMaintainer(String name, Logger logger) {
            super(name, logger);
        }

        @Override
        public void doWork() {
            try {
                if (DLedgerLeaderElector.this.dLedgerConfig.isEnableLeaderElector()) {
                    DLedgerLeaderElector.this.refreshIntervals(DLedgerLeaderElector.this.dLedgerConfig);
                    DLedgerLeaderElector.this.maintainState();
                }
                StateMaintainer.sleep(10L);
            }
            catch (Throwable t) {
                logger.error("Error in heartbeat", t);
            }
        }
    }

    public static interface RoleChangeHandler {
        public void handle(long var1, MemberState.Role var3);

        public void startup();

        public void shutdown();
    }

    private class TakeLeadershipTask {
        private LeadershipTransferRequest request;
        private CompletableFuture<LeadershipTransferResponse> responseFuture;

        private TakeLeadershipTask() {
        }

        public synchronized void update(LeadershipTransferRequest request, CompletableFuture<LeadershipTransferResponse> responseFuture) {
            this.request = request;
            this.responseFuture = responseFuture;
        }

        public synchronized void check(long term, MemberState.Role role) {
            LeadershipTransferResponse response;
            block9: {
                block10: {
                    block8: {
                        logger.trace("TakeLeadershipTask called, term={}, role={}", (Object)term, (Object)role);
                        if (DLedgerLeaderElector.this.memberState.getTermToTakeLeadership() == -1L || this.responseFuture == null) {
                            return;
                        }
                        response = null;
                        if (term <= DLedgerLeaderElector.this.memberState.getTermToTakeLeadership()) break block8;
                        response = new LeadershipTransferResponse().term(term).code(DLedgerResponseCode.EXPIRED_TERM.getCode());
                        break block9;
                    }
                    if (term != DLedgerLeaderElector.this.memberState.getTermToTakeLeadership()) break block10;
                    switch (role) {
                        case LEADER: {
                            response = new LeadershipTransferResponse().term(term).code(DLedgerResponseCode.SUCCESS.getCode());
                            break block9;
                        }
                        case FOLLOWER: {
                            response = new LeadershipTransferResponse().term(term).code(DLedgerResponseCode.TAKE_LEADERSHIP_FAILED.getCode());
                            break block9;
                        }
                        default: {
                            return;
                        }
                    }
                }
                switch (role) {
                    case FOLLOWER: {
                        response = new LeadershipTransferResponse().term(term).code(DLedgerResponseCode.TAKE_LEADERSHIP_FAILED.getCode());
                        break;
                    }
                    default: {
                        response = new LeadershipTransferResponse().term(term).code(DLedgerResponseCode.INTERNAL_ERROR.getCode());
                    }
                }
            }
            this.responseFuture.complete(response);
            logger.info("TakeLeadershipTask finished. request={}, response={}, term={}, role={}", new Object[]{this.request, response, term, role});
            DLedgerLeaderElector.this.memberState.setTermToTakeLeadership(-1L);
            this.responseFuture = null;
            this.request = null;
        }
    }
}

