/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.errors;

import com.alipay.sofa.jraft.rhea.errors.ApiException;
import com.alipay.sofa.jraft.rhea.errors.CallSelfEndpointException;
import com.alipay.sofa.jraft.rhea.errors.InvalidParameterException;
import com.alipay.sofa.jraft.rhea.errors.InvalidRegionEpochException;
import com.alipay.sofa.jraft.rhea.errors.InvalidRegionMembershipException;
import com.alipay.sofa.jraft.rhea.errors.InvalidRegionVersionException;
import com.alipay.sofa.jraft.rhea.errors.InvalidRequestException;
import com.alipay.sofa.jraft.rhea.errors.InvalidStoreStatsException;
import com.alipay.sofa.jraft.rhea.errors.LeaderNotAvailableException;
import com.alipay.sofa.jraft.rhea.errors.NoRegionFoundException;
import com.alipay.sofa.jraft.rhea.errors.NotLeaderException;
import com.alipay.sofa.jraft.rhea.errors.RangeSplitFailException;
import com.alipay.sofa.jraft.rhea.errors.RegionEngineFailException;
import com.alipay.sofa.jraft.rhea.errors.RegionHeartbeatOutOfDateException;
import com.alipay.sofa.jraft.rhea.errors.ServerBusyException;
import com.alipay.sofa.jraft.rhea.errors.StorageException;
import com.alipay.sofa.jraft.rhea.errors.StoreHeartbeatOutOfDateException;
import com.alipay.sofa.jraft.rhea.errors.UnknownServerException;
import com.alipay.sofa.jraft.rhea.util.Maps;
import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Errors {
    UNKNOWN_SERVER_ERROR(-1, "The server experienced an unexpected error when processing the request", UnknownServerException::new),
    NONE(0, null, message -> null),
    STORAGE_ERROR(1, "Disk error when trying to access log file on the disk.", StorageException::new),
    INVALID_REQUEST(2, "This most likely occurs because of a request being malformed by the client library or the message was sent to an incompatible server. See the server logs for more details.", InvalidRequestException::new),
    LEADER_NOT_AVAILABLE(3, "The leader is not available.", LeaderNotAvailableException::new),
    NOT_LEADER(4, "This is not the correct leader.", NotLeaderException::new),
    INVALID_PARAMETER(5, "Invalid parameter error, please check your input parameters. See the server logs for more details.", InvalidParameterException::new),
    NO_REGION_FOUND(6, "Can not find region error.", NoRegionFoundException::new),
    INVALID_REGION_MEMBERSHIP(7, "Invalid region membership config error (add or remove peer happened).", InvalidRegionMembershipException::new),
    INVALID_REGION_VERSION(8, "Invalid region version error (region split or merge happened).", InvalidRegionVersionException::new),
    INVALID_REGION_EPOCH(9, "Invalid region epoch (membership or version changed).", InvalidRegionEpochException::new),
    INVALID_STORE_STATS(10, "Placement driver: invalid store stats", InvalidStoreStatsException::new),
    INVALID_REGION_STATS(11, "Placement driver: invalid region stats", InvalidStoreStatsException::new),
    STORE_HEARTBEAT_OUT_OF_DATE(12, "The store heartbeat info is out of date", StoreHeartbeatOutOfDateException::new),
    REGION_HEARTBEAT_OUT_OF_DATE(13, "The region heartbeat info is out of date", RegionHeartbeatOutOfDateException::new),
    CALL_SELF_ENDPOINT_ERROR(14, "The usual reason is that the rpc call selected the self endpoint.", CallSelfEndpointException::new),
    SERVER_BUSY(15, "The server is busy now.", ServerBusyException::new),
    REGION_ENGINE_FAIL(16, "Fail to start region engine. See the server logs for more details.", RegionEngineFailException::new),
    CONFLICT_REGION_ID(17, "There is a conflict between the new region id and the existing ids. The new region cannot be created.", RangeSplitFailException::new),
    TOO_SMALL_TO_SPLIT(18, "The region size is too small to split. See the server logs for more details.", RangeSplitFailException::new);

    private static final Logger LOG;
    private static Map<Class<?>, Errors> classToError;
    private static Map<Short, Errors> codeToError;
    private final short code;
    private final ApiExceptionBuilder builder;
    private final ApiException exception;

    private Errors(int code, String defaultExceptionString, ApiExceptionBuilder builder) {
        this.code = (short)code;
        this.builder = builder;
        this.exception = builder.build(defaultExceptionString);
    }

    public ApiException exception() {
        return this.exception;
    }

    public ApiException exception(String message) {
        if (message == null) {
            return this.exception;
        }
        return this.builder.build(message);
    }

    public String exceptionName() {
        return this.exception == null ? null : this.exception.getClass().getName();
    }

    public short code() {
        return this.code;
    }

    public void maybeThrow() {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public String message() {
        if (this.exception != null) {
            return this.exception.getMessage();
        }
        return this.toString();
    }

    public static Errors forCode(short code) {
        Errors error = codeToError.get(code);
        if (error != null) {
            return error;
        }
        LOG.error("Unexpected error code: {}.", (Object)code);
        return UNKNOWN_SERVER_ERROR;
    }

    public static Errors forException(Throwable t) {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Errors error = classToError.get(clazz);
            if (error == null) continue;
            return error;
        }
        LOG.error("Unexpected error: {}.", (Object)StackTraceUtil.stackTrace(t));
        return UNKNOWN_SERVER_ERROR;
    }

    public boolean isSuccess() {
        return this == NONE;
    }

    static {
        LOG = LoggerFactory.getLogger(Errors.class);
        classToError = Maps.newHashMap();
        codeToError = Maps.newHashMap();
        for (Errors error : Errors.values()) {
            codeToError.put(error.code(), error);
            if (error.exception == null) continue;
            classToError.put(error.exception.getClass(), error);
        }
    }

    private static interface ApiExceptionBuilder {
        public ApiException build(String var1);
    }
}

