/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea;

import com.alipay.sofa.jraft.rhea.DescriberManager;
import com.alipay.sofa.jraft.util.Describer;
import com.alipay.sofa.jraft.util.FileOutputSignalHandler;
import com.alipay.sofa.jraft.util.SystemPropertyUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RheaKVDescribeSignalHandler
extends FileOutputSignalHandler {
    private static Logger LOG = LoggerFactory.getLogger(RheaKVDescribeSignalHandler.class);
    private static final String DIR = SystemPropertyUtil.get((String)"rheakv.signal.describe.dir", (String)"");
    private static final String BASE_NAME = "rheakv_describe.log";

    public void handle(String signalName) {
        List<Describer> describers = DescriberManager.getInstance().getAllDescribers();
        if (describers.isEmpty()) {
            return;
        }
        try {
            File file = this.getOutputFile(DIR, BASE_NAME);
            LOG.info("Describing rheakv with signal: {} to file: {}.", (Object)signalName, (Object)file);
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
                Describer.DefaultPrinter printer = new Describer.DefaultPrinter(out);
                for (Describer describer : describers) {
                    describer.describe((Describer.Printer)printer);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Fail to describe rheakv: {}.", describers, (Object)e);
        }
    }
}

