/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.mq;

import java.util.Properties;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;

public class MqConsumer {
    public static final String THREAD_NUM_KEY = "threadNum";
    private DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer();

    public MqConsumer(Properties properties) {
        this(properties, properties.getProperty("NAMESRV_ADDR"));
    }

    public MqConsumer(Properties properties, String nameSrv) {
        this.defaultMQPushConsumer.setNamesrvAddr(nameSrv);
        this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(1);
        this.defaultMQPushConsumer.setPullBatchSize(Integer.parseInt(properties.getProperty("pullBatch", "64")));
        if (properties.get(THREAD_NUM_KEY) != null) {
            this.defaultMQPushConsumer.setConsumeThreadMin(Integer.valueOf((String)properties.get(THREAD_NUM_KEY)).intValue());
            this.defaultMQPushConsumer.setConsumeThreadMax(Integer.valueOf((String)properties.get(THREAD_NUM_KEY)).intValue());
        }
        this.defaultMQPushConsumer.setInstanceName(this.buildInstanceName());
        this.defaultMQPushConsumer.setVipChannelEnabled(false);
    }

    public String buildInstanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + System.nanoTime();
    }

    public void setConsumerGroup(String consumerGroup) {
        this.defaultMQPushConsumer.setConsumerGroup(consumerGroup);
    }

    public DefaultMQPushConsumer getDefaultMQPushConsumer() {
        return this.defaultMQPushConsumer;
    }

    public void setMessageListener(MessageListener messageListener) {
        if (messageListener instanceof MessageListenerOrderly) {
            this.defaultMQPushConsumer.registerMessageListener((MessageListenerOrderly)messageListener);
        } else {
            this.defaultMQPushConsumer.registerMessageListener((MessageListenerConcurrently)messageListener);
        }
    }

    public void start() {
        try {
            this.defaultMQPushConsumer.start();
        }
        catch (MQClientException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MqConsumer.this.defaultMQPushConsumer.shutdown();
            }
        });
    }
}

