/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ServiceConf {
    private static final String CONF_FILE_NAME = "service.conf";
    private File confFile;
    private Properties properties;
    private int authThreadNum = 32;
    private int csRpcPort = 7001;
    private int eventNotifyRetryMaxTime = 3;
    private String eventNotifyRetryTopic;
    private String clientRetryTopic;
    private String clientP2pTopic;
    private String username;
    private String secretKey;
    private String metaAddr;

    public ServiceConf() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(CONF_FILE_NAME);
        InputStream in = classPathResource.getInputStream();
        Properties properties = new Properties();
        properties.load(in);
        in.close();
        this.properties = properties;
        MixAll.properties2Object((Properties)properties, (Object)this);
        this.confFile = new File(classPathResource.getURL().getFile());
        if (StringUtils.isBlank((CharSequence)this.clientRetryTopic)) {
            throw new RemoteException("clientRetryTopic is blank");
        }
        if (StringUtils.isBlank((CharSequence)this.eventNotifyRetryTopic)) {
            throw new RemoteException("eventNotifyRetryTopic is blank");
        }
        if (StringUtils.isBlank((CharSequence)this.metaAddr)) {
            throw new RemoteException("metaAddr is blank");
        }
    }

    public File getConfFile() {
        return this.confFile;
    }

    public int getAuthThreadNum() {
        return this.authThreadNum;
    }

    public void setAuthThreadNum(int authThreadNum) {
        this.authThreadNum = authThreadNum;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public int getCsRpcPort() {
        return this.csRpcPort;
    }

    public void setCsRpcPort(int csRpcPort) {
        this.csRpcPort = csRpcPort;
    }

    public int getEventNotifyRetryMaxTime() {
        return this.eventNotifyRetryMaxTime;
    }

    public void setEventNotifyRetryMaxTime(int eventNotifyRetryMaxTime) {
        this.eventNotifyRetryMaxTime = eventNotifyRetryMaxTime;
    }

    public String getEventNotifyRetryTopic() {
        return this.eventNotifyRetryTopic;
    }

    public String getMetaAddr() {
        return this.metaAddr;
    }

    public void setMetaAddr(String metaAddr) {
        this.metaAddr = metaAddr;
    }

    public void setEventNotifyRetryTopic(String eventNotifyRetryTopic) {
        this.eventNotifyRetryTopic = eventNotifyRetryTopic;
    }

    public String getClientRetryTopic() {
        return this.clientRetryTopic;
    }

    public void setClientRetryTopic(String clientRetryTopic) {
        this.clientRetryTopic = clientRetryTopic;
    }

    public String getClientP2pTopic() {
        return this.clientP2pTopic;
    }

    public void setClientP2pTopic(String clientP2pTopic) {
        this.clientP2pTopic = clientP2pTopic;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

