/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;

public class MessageImpl
implements Message {
    protected final Collection<String> keys;
    final byte[] body;
    private final String topic;
    @Nullable
    private final String tag;
    @Nullable
    private final String messageGroup;
    @Nullable
    private final Long deliveryTimestamp;
    private final Map<String, String> properties;

    MessageImpl(String topic, byte[] body, @Nullable String tag, Collection<String> keys, @Nullable String messageGroup, @Nullable Long deliveryTimestamp, Map<String, String> properties) {
        this.topic = topic;
        this.body = body;
        this.tag = tag;
        this.messageGroup = messageGroup;
        this.deliveryTimestamp = deliveryTimestamp;
        this.keys = keys;
        this.properties = properties;
    }

    MessageImpl(Message message) {
        this.topic = message.getTopic();
        if (message instanceof MessageImpl) {
            MessageImpl impl = (MessageImpl)message;
            this.body = impl.body;
        } else {
            ByteBuffer body = message.getBody();
            byte[] bytes = new byte[body.remaining()];
            body.get(bytes);
            this.body = bytes;
        }
        this.tag = message.getTag().orElse(null);
        this.messageGroup = message.getMessageGroup().orElse(null);
        this.deliveryTimestamp = message.getDeliveryTimestamp().orElse(null);
        this.keys = message.getKeys();
        this.properties = message.getProperties();
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    @Override
    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    @Override
    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @Override
    public Collection<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    @Override
    public Optional<Long> getDeliveryTimestamp() {
        return Optional.ofNullable(this.deliveryTimestamp);
    }

    @Override
    public Optional<String> getMessageGroup() {
        return Optional.ofNullable(this.messageGroup);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("topic", this.topic).add("tag", this.tag).add("messageGroup", this.messageGroup).add("deliveryTimestamp", this.deliveryTimestamp).add("keys", this.keys).add("properties", this.properties).toString();
    }
}

