/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.java.message.MessageIdImpl;
import org.apache.rocketmq.client.java.misc.Utilities;

public class MessageIdCodec {
    public static final int MESSAGE_ID_LENGTH_FOR_V1_OR_LATER = 34;
    public static final String MESSAGE_ID_VERSION_V0 = "00";
    public static final String MESSAGE_ID_VERSION_V1 = "01";
    private static final MessageIdCodec INSTANCE = new MessageIdCodec();
    private final String processFixedStringV1;
    private final long secondsSinceCustomEpoch;
    private final long secondsStartTimestamp;
    private long seconds;
    private final AtomicInteger sequence;

    private MessageIdCodec() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        byte[] prefix0 = Utilities.macAddress();
        buffer.put(prefix0, 0, 6);
        ByteBuffer pidBuffer = ByteBuffer.allocate(4);
        pidBuffer.order(ByteOrder.BIG_ENDIAN);
        int pid = Utilities.processId();
        pidBuffer.putInt(pid);
        buffer.put(pidBuffer.array(), 2, 2);
        buffer.flip();
        this.processFixedStringV1 = Utilities.encodeHexString(buffer, false);
        this.secondsSinceCustomEpoch = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.customEpochMillis());
        this.secondsStartTimestamp = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
        this.seconds = this.deltaSeconds();
        this.sequence = new AtomicInteger(0);
    }

    public static MessageIdCodec getInstance() {
        return INSTANCE;
    }

    private long customEpochMillis() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2021);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    private long deltaSeconds() {
        return TimeUnit.NANOSECONDS.toSeconds(System.nanoTime()) - this.secondsStartTimestamp + this.secondsSinceCustomEpoch;
    }

    public MessageId nextMessageId() {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.BIG_ENDIAN);
        ByteBuffer deltaSecondsBuffer = ByteBuffer.allocate(8);
        deltaSecondsBuffer.order(ByteOrder.BIG_ENDIAN);
        long deltaSeconds = this.deltaSeconds();
        if (this.seconds != deltaSeconds) {
            this.seconds = deltaSeconds;
        }
        deltaSecondsBuffer.putLong(this.seconds);
        buffer.put(deltaSecondsBuffer.array(), 4, 4);
        buffer.putInt(this.sequence.getAndIncrement());
        buffer.flip();
        String suffix = this.processFixedStringV1 + Utilities.encodeHexString(buffer, false);
        return new MessageIdImpl(MESSAGE_ID_VERSION_V1, suffix);
    }

    public MessageId decode(String messageId) {
        if (34 != messageId.length()) {
            return new MessageIdImpl(MESSAGE_ID_VERSION_V0, messageId);
        }
        return new MessageIdImpl(messageId.substring(0, 2), messageId.substring(2));
    }
}

