/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.impl.consumer.ConsumeService;
import org.apache.rocketmq.client.java.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class StandardConsumeService
extends ConsumeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardConsumeService.class);

    public StandardConsumeService(ClientId clientId, MessageListener messageListener, ThreadPoolExecutor consumptionExecutor, MessageInterceptor messageInterceptor, ScheduledExecutorService scheduler) {
        super(clientId, messageListener, consumptionExecutor, messageInterceptor, scheduler);
    }

    @Override
    public void consume(final ProcessQueue pq, List<MessageViewImpl> messageViews) {
        for (final MessageViewImpl messageView : messageViews) {
            if (messageView.isCorrupted()) {
                LOGGER.error("Message is corrupted for standard consumption, prepare to discard it, mq={}, messageId={}, clientId={}", pq.getMessageQueue(), messageView.getMessageId(), this.clientId);
                pq.discardMessage(messageView);
                continue;
            }
            ListenableFuture<ConsumeResult> future = this.consume(messageView);
            Futures.addCallback(future, new FutureCallback<ConsumeResult>(){

                @Override
                public void onSuccess(ConsumeResult consumeResult) {
                    pq.eraseMessage(messageView, consumeResult);
                }

                @Override
                public void onFailure(Throwable t) {
                    LOGGER.error("[Bug] Exception raised in consumption callback, clientId={}", (Object)StandardConsumeService.this.clientId, (Object)t);
                }
            }, MoreExecutors.directExecutor());
        }
    }
}

