/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl.consumer;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.rocketmq.client.apis.consumer.ConsumeResult;
import org.apache.rocketmq.client.apis.consumer.MessageListener;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageHookPointsStatus;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.message.MessageViewImpl;
import org.apache.rocketmq.shaded.com.google.common.base.Stopwatch;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ConsumeTask
implements Callable<ConsumeResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeTask.class);
    private final String clientId;
    private final MessageListener messageListener;
    private final MessageViewImpl messageView;
    private final MessageInterceptor messageInterceptor;

    public ConsumeTask(String clientId, MessageListener messageListener, MessageViewImpl messageView, MessageInterceptor messageInterceptor) {
        this.clientId = clientId;
        this.messageListener = messageListener;
        this.messageView = messageView;
        this.messageInterceptor = messageInterceptor;
    }

    @Override
    public ConsumeResult call() {
        ConsumeResult consumeResult;
        List<MessageCommon> messageCommons = Collections.singletonList(this.messageView.getMessageCommon());
        this.messageInterceptor.doBefore(MessageHookPoints.CONSUME, messageCommons);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            consumeResult = this.messageListener.consume(this.messageView);
        }
        catch (Throwable t) {
            LOGGER.error("Message listener raised an exception while consuming messages, client id={}", (Object)this.clientId, (Object)t);
            consumeResult = ConsumeResult.FAILURE;
        }
        Duration duration = stopwatch.elapsed();
        MessageHookPointsStatus status = ConsumeResult.SUCCESS.equals((Object)consumeResult) ? MessageHookPointsStatus.OK : MessageHookPointsStatus.ERROR;
        this.messageInterceptor.doAfter(MessageHookPoints.CONSUME, messageCommons, duration, status);
        return consumeResult;
    }
}

