/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.codec.BuiltinCodecSupport;
import io.r2dbc.postgresql.codec.PostgresTypeIdentifier;
import io.r2dbc.postgresql.codec.PostgresqlObjectId;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.util.Assert;
import io.r2dbc.postgresql.util.ByteBufUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import reactor.util.annotation.Nullable;

final class InetAddressCodec
extends BuiltinCodecSupport<InetAddress> {
    InetAddressCodec(ByteBufAllocator byteBufAllocator) {
        super(InetAddress.class, byteBufAllocator, PostgresqlObjectId.INET, PostgresqlObjectId.INET_ARRAY, InetAddress::getHostAddress);
    }

    @Override
    InetAddress doDecode(ByteBuf buffer, PostgresTypeIdentifier dataType, @Nullable Format format, @Nullable Class<? extends InetAddress> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        try {
            if (format == Format.FORMAT_BINARY) {
                int readableBytes = buffer.readableBytes();
                if (readableBytes == 8) {
                    buffer.skipBytes(4);
                    byte[] addr = new byte[4];
                    buffer.readBytes(addr);
                    return InetAddress.getByAddress(addr);
                }
                throw new IllegalArgumentException("Cannot decode InetAddress. Available bytes: " + readableBytes);
            }
            return InetAddress.getByName(ByteBufUtils.decode(buffer));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

