/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Assignment;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;
import org.apache.james.backends.cassandra.init.configuration.JamesExecutionProfiles;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.ids.CassandraMessageId;
import org.apache.james.mailbox.cassandra.mail.CassandraMessageMetadata;
import org.apache.james.mailbox.cassandra.mail.FlagsExtractor;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIdTable;
import org.apache.james.mailbox.cassandra.table.CassandraMessageIds;
import org.apache.james.mailbox.cassandra.table.CassandraMessageV3Table;
import org.apache.james.mailbox.cassandra.table.Flag;
import org.apache.james.mailbox.cassandra.table.MessageIdToImapUid;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;
import org.apache.james.mailbox.model.UpdatedFlags;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMessageIdToImapUidDAO {
    private static final String MOD_SEQ_CONDITION = "modSeqCondition";
    private static final String ADDED_USERS_FLAGS = "added_user_flags";
    private static final String REMOVED_USERS_FLAGS = "removed_user_flags";
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final BlobId.Factory blobIdFactory;
    private final PreparedStatement delete;
    private final PreparedStatement insert;
    private final PreparedStatement insertForced;
    private final PreparedStatement update;
    private final PreparedStatement selectAll;
    private final PreparedStatement select;
    private final PreparedStatement listStatement;
    private final CassandraConfiguration cassandraConfiguration;
    private final CqlSession session;
    private final DriverExecutionProfile lwtProfile;

    @Inject
    public CassandraMessageIdToImapUidDAO(CqlSession session, BlobId.Factory blobIdFactory, CassandraConfiguration cassandraConfiguration) {
        this.session = session;
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.blobIdFactory = blobIdFactory;
        this.cassandraConfiguration = cassandraConfiguration;
        this.delete = this.prepareDelete();
        this.insert = this.prepareInsert();
        this.insertForced = this.prepareInsertForced();
        this.update = this.prepareUpdate();
        this.selectAll = this.prepareSelectAll();
        this.select = this.prepareSelect();
        this.listStatement = this.prepareList();
        this.lwtProfile = JamesExecutionProfiles.getLWTProfile((CqlSession)session);
    }

    private PreparedStatement prepareDelete() {
        return this.session.prepare(((Delete)QueryBuilder.deleteFrom((String)"imapUidTable").where(List.of((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID))))).build());
    }

    private PreparedStatement prepareInsert() {
        RegularInsert insert = QueryBuilder.insertInto((String)"imapUidTable").value(CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)).value(CassandraMessageIds.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)).value(CassandraMessageIds.IMAP_UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID)).value(MessageIdToImapUid.THREAD_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.THREAD_ID)).value(MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)).value(Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)).value(Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)).value(Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)).value(Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)).value(Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)).value(Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)).value(Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER)).value(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER_FLAGS)).value(CassandraMessageV3Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE)).value(CassandraMessageIdTable.SAVE_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE)).value(CassandraMessageV3Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET)).value(CassandraMessageV3Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS)).value(CassandraMessageV3Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT));
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return this.session.prepare(insert.ifNotExists().build());
        }
        return this.session.prepare(((Update)QueryBuilder.update((String)"imapUidTable").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)MessageIdToImapUid.THREAD_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.THREAD_ID)), Assignment.setColumn((CqlIdentifier)MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)), Assignment.setColumn((CqlIdentifier)Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)), Assignment.setColumn((CqlIdentifier)Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)), Assignment.setColumn((CqlIdentifier)Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)), Assignment.setColumn((CqlIdentifier)Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)), Assignment.setColumn((CqlIdentifier)Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)), Assignment.setColumn((CqlIdentifier)Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)), Assignment.setColumn((CqlIdentifier)Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE)), Assignment.setColumn((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS)), Assignment.setColumn((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT))}).append(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER_FLAGS)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))})).build());
    }

    private PreparedStatement prepareInsertForced() {
        RegularInsert insert = QueryBuilder.insertInto((String)"imapUidTable").value(CassandraMessageIds.MESSAGE_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)).value(CassandraMessageIds.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)).value(CassandraMessageIds.IMAP_UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID)).value(MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)).value(Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)).value(Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)).value(Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)).value(Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)).value(Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)).value(Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)).value(Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER)).value(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER_FLAGS)).value(CassandraMessageV3Table.INTERNAL_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.INTERNAL_DATE)).value(CassandraMessageIdTable.SAVE_DATE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIdTable.SAVE_DATE)).value(CassandraMessageV3Table.BODY_START_OCTET, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.BODY_START_OCTET)).value(CassandraMessageV3Table.FULL_CONTENT_OCTETS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.FULL_CONTENT_OCTETS)).value(CassandraMessageV3Table.HEADER_CONTENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageV3Table.HEADER_CONTENT));
        return this.session.prepare(insert.build());
    }

    private PreparedStatement prepareUpdate() {
        Update update = (Update)QueryBuilder.update((String)"imapUidTable").set(new Assignment[]{Assignment.setColumn((CqlIdentifier)MessageIdToImapUid.MOD_SEQ, (Term)QueryBuilder.bindMarker((CqlIdentifier)MessageIdToImapUid.MOD_SEQ)), Assignment.setColumn((CqlIdentifier)Flag.ANSWERED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.ANSWERED)), Assignment.setColumn((CqlIdentifier)Flag.DELETED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DELETED)), Assignment.setColumn((CqlIdentifier)Flag.DRAFT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.DRAFT)), Assignment.setColumn((CqlIdentifier)Flag.FLAGGED, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.FLAGGED)), Assignment.setColumn((CqlIdentifier)Flag.RECENT, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.RECENT)), Assignment.setColumn((CqlIdentifier)Flag.SEEN, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.SEEN)), Assignment.setColumn((CqlIdentifier)Flag.USER, (Term)QueryBuilder.bindMarker((CqlIdentifier)Flag.USER))}).append(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((String)ADDED_USERS_FLAGS)).remove(Flag.USER_FLAGS, (Term)QueryBuilder.bindMarker((String)REMOVED_USERS_FLAGS)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.IMAP_UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.IMAP_UID))});
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return this.session.prepare(((Update)update.ifColumn(MessageIdToImapUid.MOD_SEQ).isEqualTo((Term)QueryBuilder.bindMarker((String)MOD_SEQ_CONDITION))).build());
        }
        return this.session.prepare(update.build());
    }

    private PreparedStatement prepareSelectAll() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"imapUidTable").all().where((Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)))).build());
    }

    private PreparedStatement prepareList() {
        return this.session.prepare(QueryBuilder.selectFrom((String)"imapUidTable").all().build());
    }

    private PreparedStatement prepareSelect() {
        return this.session.prepare(((Select)QueryBuilder.selectFrom((String)"imapUidTable").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MESSAGE_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MESSAGE_ID)), (Relation)Relation.column((CqlIdentifier)CassandraMessageIds.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraMessageIds.MAILBOX_ID))})).build());
    }

    public Mono<Void> delete(CassandraMessageId messageId, CassandraId mailboxId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.delete.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get())).setUuid(CassandraMessageIds.MAILBOX_ID, mailboxId.asUuid()));
    }

    public Mono<Void> insert(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatementBuilder statementBuilder = this.insert.boundStatementBuilder(new Object[0]);
        if (metadata.getComposedMessageId().getFlags().getUserFlags().length == 0) {
            statementBuilder.unset(Flag.USER_FLAGS);
        } else {
            statementBuilder.setSet(Flag.USER_FLAGS, (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()), String.class);
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)statementBuilder.set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)composedMessageId.getMessageId()).get(), TypeCodecs.TIMEUUID)).set(CassandraMessageIds.MAILBOX_ID, (Object)((CassandraId)composedMessageId.getMailboxId()).asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, composedMessageId.getUid().asLong())).setLong(MessageIdToImapUid.MOD_SEQ, metadata.getComposedMessageId().getModSeq().asLong())).setUuid(MessageIdToImapUid.THREAD_ID, ((CassandraMessageId)threadId.getBaseMessageId()).get())).setBoolean(Flag.ANSWERED, flags.contains(Flags.Flag.ANSWERED))).setBoolean(Flag.DELETED, flags.contains(Flags.Flag.DELETED))).setBoolean(Flag.DRAFT, flags.contains(Flags.Flag.DRAFT))).setBoolean(Flag.FLAGGED, flags.contains(Flags.Flag.FLAGGED))).setBoolean(Flag.RECENT, flags.contains(Flags.Flag.RECENT))).setBoolean(Flag.SEEN, flags.contains(Flags.Flag.SEEN))).setBoolean(Flag.USER, flags.contains(Flags.Flag.USER))).setInstant(CassandraMessageV3Table.INTERNAL_DATE, metadata.getInternalDate().get().toInstant())).setInstant(CassandraMessageIdTable.SAVE_DATE, (Instant)metadata.getSaveDate().map(Date::toInstant).orElse(null))).setInt(CassandraMessageV3Table.BODY_START_OCTET, Math.toIntExact(metadata.getBodyStartOctet().get()))).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, metadata.getSize().get().longValue())).setString(CassandraMessageV3Table.HEADER_CONTENT, metadata.getHeaderContent().get().asString())).build());
    }

    public Mono<Void> insertForce(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)((BoundStatement)this.insertForced.bind(new Object[0]).set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)composedMessageId.getMessageId()).get(), TypeCodecs.TIMEUUID)).set(CassandraMessageIds.MAILBOX_ID, (Object)((CassandraId)composedMessageId.getMailboxId()).asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, composedMessageId.getUid().asLong())).setLong(MessageIdToImapUid.MOD_SEQ, metadata.getComposedMessageId().getModSeq().asLong())).setBoolean(Flag.ANSWERED, flags.contains(Flags.Flag.ANSWERED))).setBoolean(Flag.DELETED, flags.contains(Flags.Flag.DELETED))).setBoolean(Flag.DRAFT, flags.contains(Flags.Flag.DRAFT))).setBoolean(Flag.FLAGGED, flags.contains(Flags.Flag.FLAGGED))).setBoolean(Flag.RECENT, flags.contains(Flags.Flag.RECENT))).setBoolean(Flag.SEEN, flags.contains(Flags.Flag.SEEN))).setBoolean(Flag.USER, flags.contains(Flags.Flag.USER))).setSet(Flag.USER_FLAGS, (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()), String.class)).setInstant(CassandraMessageV3Table.INTERNAL_DATE, metadata.getInternalDate().get().toInstant())).setInstant(CassandraMessageIdTable.SAVE_DATE, (Instant)metadata.getSaveDate().map(Date::toInstant).orElse(null))).setInt(CassandraMessageV3Table.BODY_START_OCTET, Math.toIntExact(metadata.getBodyStartOctet().get()))).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, metadata.getSize().get().longValue())).setString(CassandraMessageV3Table.HEADER_CONTENT, metadata.getHeaderContent().get().asString()));
    }

    public Mono<Boolean> updateMetadata(ComposedMessageId id, UpdatedFlags updatedFlags, ModSeq previousModeq) {
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.updateBoundStatement(id, updatedFlags, previousModeq));
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateBoundStatement(id, updatedFlags, previousModeq)).thenReturn((Object)true);
    }

    private BoundStatement updateBoundStatement(ComposedMessageId id, UpdatedFlags updatedFlags, ModSeq previousModeq) {
        BoundStatementBuilder statementBuilder = (BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)this.update.boundStatementBuilder(new Object[0]).setLong(MessageIdToImapUid.MOD_SEQ, updatedFlags.getModSeq().asLong())).setUuid(CassandraMessageIds.MESSAGE_ID, ((CassandraMessageId)id.getMessageId()).get())).setUuid(CassandraMessageIds.MAILBOX_ID, ((CassandraId)id.getMailboxId()).asUuid())).setLong(CassandraMessageIds.IMAP_UID, id.getUid().asLong());
        if (updatedFlags.isChanged(Flags.Flag.ANSWERED)) {
            statementBuilder.setBoolean(Flag.ANSWERED, updatedFlags.isModifiedToSet(Flags.Flag.ANSWERED));
        } else {
            statementBuilder.unset(Flag.ANSWERED);
        }
        if (updatedFlags.isChanged(Flags.Flag.DRAFT)) {
            statementBuilder.setBoolean(Flag.DRAFT, updatedFlags.isModifiedToSet(Flags.Flag.DRAFT));
        } else {
            statementBuilder.unset(Flag.DRAFT);
        }
        if (updatedFlags.isChanged(Flags.Flag.FLAGGED)) {
            statementBuilder.setBoolean(Flag.FLAGGED, updatedFlags.isModifiedToSet(Flags.Flag.FLAGGED));
        } else {
            statementBuilder.unset(Flag.FLAGGED);
        }
        if (updatedFlags.isChanged(Flags.Flag.DELETED)) {
            statementBuilder.setBoolean(Flag.DELETED, updatedFlags.isModifiedToSet(Flags.Flag.DELETED));
        } else {
            statementBuilder.unset(Flag.DELETED);
        }
        if (updatedFlags.isChanged(Flags.Flag.RECENT)) {
            statementBuilder.setBoolean(Flag.RECENT, updatedFlags.getNewFlags().contains(Flags.Flag.RECENT));
        } else {
            statementBuilder.unset(Flag.RECENT);
        }
        if (updatedFlags.isChanged(Flags.Flag.SEEN)) {
            statementBuilder.setBoolean(Flag.SEEN, updatedFlags.isModifiedToSet(Flags.Flag.SEEN));
        } else {
            statementBuilder.unset(Flag.SEEN);
        }
        if (updatedFlags.isChanged(Flags.Flag.USER)) {
            statementBuilder.setBoolean(Flag.USER, updatedFlags.isModifiedToSet(Flags.Flag.USER));
        } else {
            statementBuilder.unset(Flag.USER);
        }
        Sets.SetView removedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()));
        Sets.SetView addedFlags = Sets.difference((Set)ImmutableSet.copyOf((Object[])updatedFlags.getNewFlags().getUserFlags()), (Set)ImmutableSet.copyOf((Object[])updatedFlags.getOldFlags().getUserFlags()));
        if (addedFlags.isEmpty()) {
            statementBuilder.unset(ADDED_USERS_FLAGS);
        } else {
            statementBuilder.setSet(ADDED_USERS_FLAGS, (Set)addedFlags, String.class);
        }
        if (removedFlags.isEmpty()) {
            statementBuilder.unset(REMOVED_USERS_FLAGS);
        } else {
            statementBuilder.setSet(REMOVED_USERS_FLAGS, (Set)removedFlags, String.class);
        }
        if (this.cassandraConfiguration.isMessageWriteStrongConsistency()) {
            statementBuilder.setLong(MOD_SEQ_CONDITION, previousModeq.asLong());
        }
        return statementBuilder.build();
    }

    public Flux<CassandraMessageMetadata> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId, JamesExecutionProfiles.ConsistencyChoice readConsistencyChoice) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.setExecutionProfileIfNeeded(this.selectStatement(messageId, mailboxId), readConsistencyChoice)).map(this::toComposedMessageIdWithMetadata);
    }

    @VisibleForTesting
    public Flux<CassandraMessageMetadata> retrieve(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return this.retrieve(messageId, mailboxId, JamesExecutionProfiles.ConsistencyChoice.STRONG);
    }

    public Flux<CassandraMessageMetadata> retrieveAllMessages() {
        return this.cassandraAsyncExecutor.executeRows(this.listStatement.bind(new Object[0]).setTimeout(Duration.ofDays(1L))).map(this::toComposedMessageIdWithMetadata);
    }

    private CassandraMessageMetadata toComposedMessageIdWithMetadata(Row row) {
        CassandraMessageId messageId = CassandraMessageId.Factory.of(row.getUuid(CassandraMessageIds.MESSAGE_ID));
        return CassandraMessageMetadata.builder().ids(ComposedMessageIdWithMetaData.builder().composedMessageId(new ComposedMessageId((MailboxId)CassandraId.of(row.getUuid(CassandraMessageIds.MAILBOX_ID)), (MessageId)messageId, MessageUid.of((long)row.getLong(CassandraMessageIds.IMAP_UID)))).flags(FlagsExtractor.getFlags(row)).threadId(this.getThreadIdFromRow(row, messageId)).modSeq(ModSeq.of((long)row.getLong(MessageIdToImapUid.MOD_SEQ))).build()).bodyStartOctet((Integer)row.get(CassandraMessageV3Table.BODY_START_OCTET, Integer.class)).internalDate(Optional.ofNullable((Instant)row.get(CassandraMessageV3Table.INTERNAL_DATE, TypeCodecs.TIMESTAMP)).map(Date::from)).saveDate(Optional.ofNullable((Instant)row.get(CassandraMessageIdTable.SAVE_DATE, TypeCodecs.TIMESTAMP)).map(Date::from)).size((Long)row.get(CassandraMessageV3Table.FULL_CONTENT_OCTETS, Long.class)).headerContent(Optional.ofNullable(row.getString(CassandraMessageV3Table.HEADER_CONTENT)).map(arg_0 -> ((BlobId.Factory)this.blobIdFactory).parse(arg_0))).build();
    }

    private ThreadId getThreadIdFromRow(Row row, MessageId messageId) {
        UUID threadIdUUID = (UUID)row.get(MessageIdToImapUid.THREAD_ID, TypeCodecs.TIMEUUID);
        if (threadIdUUID == null) {
            return ThreadId.fromBaseMessageId((MessageId)messageId);
        }
        return ThreadId.fromBaseMessageId((MessageId)CassandraMessageId.Factory.of(threadIdUUID));
    }

    private BoundStatement selectStatement(CassandraMessageId messageId, Optional<CassandraId> mailboxId) {
        return mailboxId.map(cassandraId -> (BoundStatement)((BoundStatement)this.select.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get())).setUuid(CassandraMessageIds.MAILBOX_ID, cassandraId.asUuid())).orElseGet(() -> (BoundStatement)this.selectAll.bind(new Object[0]).setUuid(CassandraMessageIds.MESSAGE_ID, messageId.get()));
    }

    private BoundStatement setExecutionProfileIfNeeded(BoundStatement statement, JamesExecutionProfiles.ConsistencyChoice consistencyChoice) {
        if (consistencyChoice.equals((Object)JamesExecutionProfiles.ConsistencyChoice.STRONG)) {
            return (BoundStatement)statement.setExecutionProfile(this.lwtProfile);
        }
        return statement;
    }

    @VisibleForTesting
    Mono<Void> insertNullInternalDateAndHeaderContent(CassandraMessageMetadata metadata) {
        ComposedMessageId composedMessageId = metadata.getComposedMessageId().getComposedMessageId();
        Flags flags = metadata.getComposedMessageId().getFlags();
        ThreadId threadId = metadata.getComposedMessageId().getThreadId();
        BoundStatementBuilder statementBuilder = this.insert.boundStatementBuilder(new Object[0]);
        if (metadata.getComposedMessageId().getFlags().getUserFlags().length == 0) {
            statementBuilder.unset(Flag.USER_FLAGS);
        } else {
            statementBuilder.setSet(Flag.USER_FLAGS, (Set)ImmutableSet.copyOf((Object[])flags.getUserFlags()), String.class);
        }
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)((BoundStatementBuilder)statementBuilder.set(CassandraMessageIds.MESSAGE_ID, (Object)((CassandraMessageId)composedMessageId.getMessageId()).get(), TypeCodecs.TIMEUUID)).set(CassandraMessageIds.MAILBOX_ID, (Object)((CassandraId)composedMessageId.getMailboxId()).asUuid(), TypeCodecs.TIMEUUID)).setLong(CassandraMessageIds.IMAP_UID, composedMessageId.getUid().asLong())).setLong(MessageIdToImapUid.MOD_SEQ, metadata.getComposedMessageId().getModSeq().asLong())).setUuid(MessageIdToImapUid.THREAD_ID, ((CassandraMessageId)threadId.getBaseMessageId()).get())).setBoolean(Flag.ANSWERED, flags.contains(Flags.Flag.ANSWERED))).setBoolean(Flag.DELETED, flags.contains(Flags.Flag.DELETED))).setBoolean(Flag.DRAFT, flags.contains(Flags.Flag.DRAFT))).setBoolean(Flag.FLAGGED, flags.contains(Flags.Flag.FLAGGED))).setBoolean(Flag.RECENT, flags.contains(Flags.Flag.RECENT))).setBoolean(Flag.SEEN, flags.contains(Flags.Flag.SEEN))).setBoolean(Flag.USER, flags.contains(Flags.Flag.USER))).setInstant(CassandraMessageV3Table.INTERNAL_DATE, null)).setInt(CassandraMessageV3Table.BODY_START_OCTET, 0)).setLong(CassandraMessageV3Table.FULL_CONTENT_OCTETS, 0L)).setString(CassandraMessageV3Table.HEADER_CONTENT, null)).build());
    }
}

