/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import reactor.core.publisher.Mono;

public class CassandraSieveQuotaDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement selectClusterQuotaStatement;
    private final PreparedStatement selectSpaceUsedByUserStatement;
    private final PreparedStatement selectUserQuotaStatement;
    private final PreparedStatement updateClusterQuotaStatement;
    private final PreparedStatement updateUserQuotaStatement;
    private final PreparedStatement updateSpaceUsedStatement;
    private final PreparedStatement deleteClusterQuotaStatement;
    private final PreparedStatement deleteUserQuotaStatement;

    @Inject
    public CassandraSieveQuotaDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"value"}).from("sieve_cluster_quota").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
        this.selectSpaceUsedByUserStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"space_used"}).from("sieve_space").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.selectUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"quota"}).from("sieve_quota").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.updateClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_cluster_quota").with(QueryBuilder.set((String)"value", (Object)QueryBuilder.bindMarker((String)"value"))).where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
        this.updateSpaceUsedStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_space").with(QueryBuilder.incr((String)"space_used", (BindMarker)QueryBuilder.bindMarker((String)"space_used"))).where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.updateUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_quota").with(QueryBuilder.set((String)"quota", (Object)QueryBuilder.bindMarker((String)"quota"))).where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.deleteClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_cluster_quota").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
        this.deleteUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_quota").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
    }

    public Mono<Long> spaceUsedBy(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectSpaceUsedByUserStatement.bind().setString("user_name", username.asString())).map(optional -> optional.map(row -> row.getLong("space_used")).orElse(0L));
    }

    public Mono<Void> updateSpaceUsed(Username username, long spaceUsed) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateSpaceUsedStatement.bind().setLong("space_used", spaceUsed).setString("user_name", username.asString()));
    }

    public Mono<Optional<QuotaSizeLimit>> getQuota() {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectClusterQuotaStatement.bind().setString("name", "cluster_quota")).map(optional -> optional.map(row -> QuotaSizeLimit.size((long)row.getLong("value"))));
    }

    public Mono<Void> setQuota(QuotaSizeLimit quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateClusterQuotaStatement.bind().setLong("value", quota.asLong()).setString("name", "cluster_quota"));
    }

    public Mono<Void> removeQuota() {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteClusterQuotaStatement.bind().setString("name", "cluster_quota"));
    }

    public Mono<Optional<QuotaSizeLimit>> getQuota(Username username) {
        return this.cassandraAsyncExecutor.executeSingleRowOptional((Statement)this.selectUserQuotaStatement.bind().setString("user_name", username.asString())).map(optional -> optional.map(row -> QuotaSizeLimit.size((long)row.getLong("quota"))));
    }

    public Mono<Void> setQuota(Username username, QuotaSizeLimit quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateUserQuotaStatement.bind().setLong("quota", quota.asLong()).setString("user_name", username.asString()));
    }

    public Mono<Void> removeQuota(Username username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteUserQuotaStatement.bind().setString("user_name", username.asString()));
    }
}

