/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlanNodeSearcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ApplyNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.CorrelatedJoinNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations.PlanOptimizer;
import org.apache.iotdb.rpc.TSStatusCode;

public class CheckSubqueryNodesAreRewritten
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        PlanNodeSearcher.searchFrom(plan).where(ApplyNode.class::isInstance).findFirst().ifPresent(node -> {
            ApplyNode applyNode = (ApplyNode)node;
            throw this.error(applyNode.getCorrelation());
        });
        PlanNodeSearcher.searchFrom(plan).where(CorrelatedJoinNode.class::isInstance).findFirst().ifPresent(node -> {
            CorrelatedJoinNode correlatedJoinNode = (CorrelatedJoinNode)node;
            throw this.error(correlatedJoinNode.getCorrelation());
        });
        return plan;
    }

    private SemanticException error(List<Symbol> correlation) {
        Preconditions.checkState((!correlation.isEmpty() ? 1 : 0) != 0, (Object)"All the non correlated subqueries should be rewritten at this point");
        throw new SemanticException("Given correlated subquery is not supported", TSStatusCode.SEMANTIC_ERROR.getStatusCode());
    }
}

