/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.sys.quota;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TThrottleQuotaResp;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.statement.sys.quota.ShowThrottleQuotaStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;

public class ShowThrottleQuotaTask
implements IConfigTask {
    private ShowThrottleQuotaStatement showThrottleQuotaStatement;

    public ShowThrottleQuotaTask(ShowThrottleQuotaStatement showThrottleQuotaStatement) {
        this.showThrottleQuotaStatement = showThrottleQuotaStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showThrottleQuota(this.showThrottleQuotaStatement);
    }

    public static void buildTSBlock(TThrottleQuotaResp throttleQuotaResp, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showThrottleQuotaColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        if (throttleQuotaResp.getThrottleQuota() != null) {
            for (Map.Entry throttleQuota : throttleQuotaResp.getThrottleQuota().entrySet()) {
                for (Map.Entry entry : ((TThrottleQuota)throttleQuota.getValue()).getThrottleLimit().entrySet()) {
                    builder.getTimeColumnBuilder().writeLong(0L);
                    builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)((String)throttleQuota.getKey())));
                    builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)ShowThrottleQuotaTask.toThrottleType((ThrottleType)entry.getKey())));
                    builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)ShowThrottleQuotaTask.toQuotaLimit((ThrottleType)entry.getKey(), (TTimedQuota)entry.getValue())));
                    builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)ShowThrottleQuotaTask.toRequestType((ThrottleType)entry.getKey())));
                    builder.declarePosition();
                }
                if (((TThrottleQuota)throttleQuota.getValue()).getMemLimit() != 0L) {
                    builder.getTimeColumnBuilder().writeLong(0L);
                    builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)((String)throttleQuota.getKey())));
                    builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)"mem"));
                    builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)(((TThrottleQuota)throttleQuota.getValue()).getMemLimit() / 1024L / 1024L + "M")));
                    builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)"read"));
                    builder.declarePosition();
                }
                if (((TThrottleQuota)throttleQuota.getValue()).getCpuLimit() == 0) continue;
                builder.getTimeColumnBuilder().writeLong(0L);
                builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)((String)throttleQuota.getKey())));
                builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)"cpu"));
                builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)(((TThrottleQuota)throttleQuota.getValue()).getCpuLimit() + "")));
                builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)"read"));
                builder.declarePosition();
            }
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowThrottleQuotaHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    private static String toThrottleType(ThrottleType throttleType) {
        switch (throttleType) {
            case REQUEST_SIZE: 
            case WRITE_SIZE: 
            case READ_SIZE: {
                return "size";
            }
            case REQUEST_NUMBER: 
            case READ_NUMBER: 
            case WRITE_NUMBER: {
                return "request";
            }
        }
        return "";
    }

    private static String toRequestType(ThrottleType throttleType) {
        switch (throttleType) {
            case WRITE_SIZE: 
            case WRITE_NUMBER: {
                return "write";
            }
            case READ_SIZE: 
            case READ_NUMBER: {
                return "read";
            }
            case REQUEST_SIZE: 
            case REQUEST_NUMBER: {
                return "";
            }
        }
        throw new IllegalArgumentException("Wrong request type");
    }

    private static String toQuotaLimit(ThrottleType throttleType, TTimedQuota timedQuota) {
        switch (ShowThrottleQuotaTask.toThrottleType(throttleType)) {
            case "request": {
                return timedQuota.getSoftLimit() + "req" + File.separator + ShowThrottleQuotaTask.toTimeUnit(timedQuota.getTimeUnit());
            }
            case "size": {
                if (timedQuota.getSoftLimit() < 1024L) {
                    return timedQuota.getSoftLimit() + "B" + File.separator + ShowThrottleQuotaTask.toTimeUnit(timedQuota.getTimeUnit());
                }
                if (timedQuota.getSoftLimit() < 0x100000L) {
                    return timedQuota.getSoftLimit() / 1024L + "K" + File.separator + ShowThrottleQuotaTask.toTimeUnit(timedQuota.getTimeUnit());
                }
                return timedQuota.getSoftLimit() / 1024L / 1024L + "M" + File.separator + ShowThrottleQuotaTask.toTimeUnit(timedQuota.getTimeUnit());
            }
        }
        throw new IllegalArgumentException("Wrong request type");
    }

    private static String toTimeUnit(long timeUnit) {
        switch ((int)timeUnit) {
            case 1000: {
                return "sec";
            }
            case 60000: {
                return "min";
            }
            case 3600000: {
                return "hour";
            }
            case 86400000: {
                return "day";
            }
        }
        throw new IllegalArgumentException("Wrong unit type");
    }
}

