/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DeviceContext {
    private boolean isAligned;
    private final int templateId;

    public DeviceContext(DeviceSchemaInfo deviceSchemaInfo) {
        this.isAligned = deviceSchemaInfo.isAligned();
        this.templateId = deviceSchemaInfo.getTemplateId();
    }

    public DeviceContext(boolean isAligned, int templateId) {
        this.isAligned = isAligned;
        this.templateId = templateId;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((Boolean)this.isAligned, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.templateId, (ByteBuffer)byteBuffer);
    }

    public void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateId, (OutputStream)stream);
    }

    public static DeviceContext deserialize(ByteBuffer buffer) {
        boolean isAligned = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        int templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        return new DeviceContext(isAligned, templateId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceContext that = (DeviceContext)o;
        return this.isAligned == that.isAligned && this.templateId == that.templateId;
    }

    public int hashCode() {
        return Objects.hash(this.isAligned, this.templateId);
    }
}

