/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.api;

import org.eclipse.milo.opcua.sdk.server.Lifecycle;
import org.eclipse.milo.opcua.sdk.server.LifecycleManager;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.UaNodeManager;
import org.eclipse.milo.opcua.sdk.server.api.AddressSpaceFragment;
import org.eclipse.milo.opcua.sdk.server.api.ManagedNamespace;

public abstract class ManagedNamespaceWithLifecycle
extends ManagedNamespace
implements Lifecycle {
    private final LifecycleManager lifecycleManager = new LifecycleManager();

    public ManagedNamespaceWithLifecycle(OpcUaServer server, String namespaceUri) {
        super(server, namespaceUri);
        this.getLifecycleManager().addLifecycle(new Lifecycle(){

            @Override
            public void startup() {
                ManagedNamespaceWithLifecycle.this.registerAddressSpace(ManagedNamespaceWithLifecycle.this);
                ManagedNamespaceWithLifecycle.this.registerNodeManager(ManagedNamespaceWithLifecycle.this.getNodeManager());
            }

            @Override
            public void shutdown() {
                ManagedNamespaceWithLifecycle.this.unregisterAddressSpace(ManagedNamespaceWithLifecycle.this);
                ManagedNamespaceWithLifecycle.this.unregisterNodeManager(ManagedNamespaceWithLifecycle.this.getNodeManager());
            }
        });
    }

    @Override
    public final void startup() {
        this.lifecycleManager.startup();
    }

    @Override
    public final void shutdown() {
        this.lifecycleManager.shutdown();
    }

    protected LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    protected void registerAddressSpace(AddressSpaceFragment addressSpace) {
        this.getServer().getAddressSpaceManager().register(addressSpace);
    }

    protected void unregisterAddressSpace(AddressSpaceFragment addressSpace) {
        this.getServer().getAddressSpaceManager().unregister(addressSpace);
    }

    protected void registerNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().register(nodeManager);
    }

    protected void unregisterNodeManager(UaNodeManager nodeManager) {
        this.getServer().getAddressSpaceManager().unregister(nodeManager);
    }
}

