/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.region;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;

public class PollSpecificRegionMaintainTaskPlan
extends ConfigPhysicalPlan {
    private Set<TConsensusGroupId> regionIdSet;

    public PollSpecificRegionMaintainTaskPlan() {
        super(ConfigPhysicalPlanType.PollSpecificRegionMaintainTask);
    }

    public PollSpecificRegionMaintainTaskPlan(Set<TConsensusGroupId> regionIdSet) {
        super(ConfigPhysicalPlanType.PollSpecificRegionMaintainTask);
        this.regionIdSet = regionIdSet;
    }

    public Set<TConsensusGroupId> getRegionIdSet() {
        return this.regionIdSet;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        stream.writeInt(this.regionIdSet.size());
        for (TConsensusGroupId regionId : this.regionIdSet) {
            stream.writeInt(regionId.getType().getValue());
            stream.writeInt(regionId.getId());
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = buffer.getInt();
        this.regionIdSet = new HashSet<TConsensusGroupId>(size);
        for (int i = 0; i < size; ++i) {
            this.regionIdSet.add(new TConsensusGroupId(TConsensusGroupType.findByValue((int)buffer.getInt()), buffer.getInt()));
        }
    }
}

