/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.lowwatermark.LowWatermark;
import org.apache.ignite3.internal.network.MessagingService;
import org.apache.ignite3.internal.tx.impl.RemotelyTriggeredResourceRegistry;
import org.apache.ignite3.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite3.internal.tx.message.TxMessageGroup;

public class FinishedTransactionBatchRequestHandler {
    private final MessagingService messagingService;
    private final RemotelyTriggeredResourceRegistry resourcesRegistry;
    private final LowWatermark lowWatermark;
    private final Executor asyncExecutor;

    public FinishedTransactionBatchRequestHandler(MessagingService messagingService, RemotelyTriggeredResourceRegistry resourcesRegistry, LowWatermark lowWatermark, Executor asyncExecutor) {
        this.messagingService = messagingService;
        this.resourcesRegistry = resourcesRegistry;
        this.lowWatermark = lowWatermark;
        this.asyncExecutor = asyncExecutor;
    }

    public void start() {
        this.messagingService.addMessageHandler(TxMessageGroup.class, (msg, sender, correlationId) -> {
            if (msg instanceof FinishedTransactionsBatchMessage) {
                this.processFinishedTransactionsBatchMessage((FinishedTransactionsBatchMessage)msg);
            }
        });
    }

    private void processFinishedTransactionsBatchMessage(FinishedTransactionsBatchMessage closeCursorsMessage) {
        this.asyncExecutor.execute(() -> closeCursorsMessage.transactions().forEach(this::cleanUpForTransaction));
    }

    private void cleanUpForTransaction(UUID transactionId) {
        this.resourcesRegistry.close(transactionId);
        this.lowWatermark.unlock(transactionId);
    }
}

