/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.set;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.rel.set.IgniteSetOp;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;

public abstract class IgniteIntersect
extends Intersect
implements IgniteSetOp {
    IgniteIntersect(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, all);
    }

    protected IgniteIntersect(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        List inputs = this.getInputs();
        double rows = mq.getRowCount((RelNode)inputs.get(0));
        for (int i = 1; i < inputs.size(); ++i) {
            rows = 0.5 * Math.min(rows, mq.getRowCount((RelNode)inputs.get(i)));
        }
        return rows;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return this.computeSetOpCost(planner, mq);
    }

    @Override
    public boolean all() {
        return this.all;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addAll(this.all);
    }
}

