/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.asm;

import org.apache.ignite3.internal.configuration.DynamicConfiguration;
import org.apache.ignite3.internal.configuration.tree.InnerNode;

class SchemaClassesInfo {
    private static final String CONFIGURATION_CLASS_POSTFIX = "Configuration";
    private static final String VIEW_CLASS_POSTFIX = "View";
    private static final String CHANGE_CLASS_POSTFIX = "Change";
    private static final String DIRECT_PROXY_CLASS_POSTFIX = "DirectProxy";
    private static final String NODE_CLASS_POSTFIX = "Node";
    final Class<?> schemaClass;
    final String viewClassName;
    final String changeClassName;
    final String cfgClassName;
    final String nodeClassName;
    final String cfgImplClassName;
    final String directProxyClassName;
    Class<? extends InnerNode> nodeClass;
    Class<? extends DynamicConfiguration<?, ?>> cfgImplClass;

    SchemaClassesInfo(Class<?> schemaClass) {
        this.schemaClass = schemaClass;
        String prefix = SchemaClassesInfo.prefix(schemaClass);
        this.viewClassName = prefix + VIEW_CLASS_POSTFIX;
        this.changeClassName = prefix + CHANGE_CLASS_POSTFIX;
        this.cfgClassName = prefix + CONFIGURATION_CLASS_POSTFIX;
        this.directProxyClassName = prefix + DIRECT_PROXY_CLASS_POSTFIX;
        this.nodeClassName = prefix + NODE_CLASS_POSTFIX;
        this.cfgImplClassName = prefix + "ConfigurationImpl";
    }

    private static String prefix(Class<?> schemaClass) {
        String schemaClassName = schemaClass.getPackageName() + "." + schemaClass.getSimpleName();
        return schemaClassName.replaceAll("ConfigurationSchema$", "");
    }

    static String viewClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + VIEW_CLASS_POSTFIX;
    }

    static String changeClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + CHANGE_CLASS_POSTFIX;
    }

    static String configurationClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + CONFIGURATION_CLASS_POSTFIX;
    }

    static String nodeClassName(Class<?> schemaClass) {
        return SchemaClassesInfo.prefix(schemaClass) + NODE_CLASS_POSTFIX;
    }
}

