/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.RootKey;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.configuration.validation.Validator;

public class CompoundModule
implements ConfigurationModule {
    private final ConfigurationType type;
    private final List<ConfigurationModule> modules;

    public CompoundModule(ConfigurationType type, Collection<ConfigurationModule> modules) {
        this.type = type;
        this.modules = List.copyOf(modules);
    }

    @Override
    public ConfigurationType type() {
        return this.type;
    }

    @Override
    public Collection<RootKey<?, ?, ?>> rootKeys() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::rootKeys);
    }

    private <T> List<T> unionFromModulesExtractedWith(Function<? super ConfigurationModule, ? extends Collection<T>> extractor) {
        return this.modules.stream().flatMap(module -> ((Collection)extractor.apply((ConfigurationModule)module)).stream()).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public Set<Validator<?, ?>> validators() {
        return this.modules.stream().flatMap(module -> module.validators().stream()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::schemaExtensions);
    }

    @Override
    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::polymorphicSchemaExtensions);
    }

    @Override
    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        this.modules.forEach(module -> module.patchConfigurationWithDynamicDefaults(rootChange));
    }

    @Override
    public void migrateDeprecatedConfigurations(SuperRootChange superRootChange) {
        this.modules.forEach(module -> module.migrateDeprecatedConfigurations(superRootChange));
    }

    @Override
    public Collection<String> deletedPrefixes() {
        return this.unionFromModulesExtractedWith(ConfigurationModule::deletedPrefixes);
    }
}

