/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.exceptions;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ignite3.client.IgniteClientConnectionException;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.lang.IgniteException;

public class IgniteClientConnectionExceptionHandler
implements ExceptionHandler<IgniteClientConnectionException> {
    public int handle(ExceptionWriter writer, IgniteClientConnectionException e) {
        IgniteException rootCauseIgn;
        ErrorUiComponent.ErrorComponentBuilder errorUiBuilder = ErrorUiComponent.builder().header("Could not connect to cluster: " + e.getMessage(), new UiElement[0]);
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
        if (rootCause instanceof IgniteException && (rootCauseIgn = (IgniteException)rootCause).groupCode() == ErrorGroups.Authentication.AUTHENTICATION_ERR_GROUP.groupCode() && rootCauseIgn.code() == ErrorGroups.Authentication.INVALID_CREDENTIALS_ERR) {
            errorUiBuilder.header("Could not connect to cluster: Invalid client authentication credentials.", new UiElement[0]).details("Please check the command help for more information on how to correctly supply the client credentials.", new UiElement[0]);
        }
        writer.write(errorUiBuilder.build().render());
        return e.code();
    }

    public Class<IgniteClientConnectionException> applicableException() {
        return IgniteClientConnectionException.class;
    }
}

