/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.configs.commands;

import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.ignite.migrationtools.cli.configs.calls.ConfigurationConverterCall;
import org.apache.ignite.migrationtools.cli.exceptions.ErrorLoadingInputConfigurationHandlers;
import org.apache.ignite.migrationtools.cli.mixins.ClassloaderOption;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipelineBuilder;
import picocli.CommandLine;

@CommandLine.Command(name="configuration-converter", description={"Converters Ignite 2 configuration xml into Ignite 3 node and cluster configurations"})
public class ConfigurationConverterCmd
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Parameters(paramLabel="input-file", description={"Ignite 2 Configuration XML"})
    private Path inputFile;
    @CommandLine.Parameters(paramLabel="node-cfg-output-file", description={"Ignite 3 Configuration HOCON"})
    private Path locCfgFile;
    @CommandLine.Parameters(paramLabel="cluster-cfg-output-file", description={"Ignite 3 Configuration HOCON"})
    private Path distCfgFile;
    @CommandLine.Option(names={"-d", "--include-defaults"}, description={"Whether default values should also be written to the output files."})
    private boolean includeDefaults = false;
    @CommandLine.Mixin
    private ClassloaderOption classloaderOption;

    @Override
    public Integer call() {
        ConfigurationConverterCall call = new ConfigurationConverterCall();
        return this.runPipeline((CallExecutionPipelineBuilder)CallExecutionPipeline.builder((Call)call).exceptionHandlers(ErrorLoadingInputConfigurationHandlers.create()).inputProvider(() -> new ConfigurationConverterCall.Input(this.inputFile, this.locCfgFile, this.distCfgFile, this.includeDefaults, this.classloaderOption.clientClassLoader())));
    }
}

