/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ignite.error.code.annotations.ErrorCodeGroup;
import org.apache.ignite.lang.ErrorGroup;
import org.jetbrains.annotations.Nullable;

public class ErrorGroups {
    public static final String IGNITE_ERR_PREFIX = "IGN";
    private static final String PLACEHOLDER = "${ERROR_PREFIX}";
    private static final String EXCEPTION_MESSAGE_STRING_PATTERN = "(.*)(${ERROR_PREFIX})-([A-Z]+)-(\\d+)(\\s?)(.*)( TraceId:)([a-f0-9]{8})";
    private static Pattern EXCEPTION_MESSAGE_PATTERN;
    private static final HashSet<String> REGISTERED_ERROR_PREFIXES;
    private static final Map<Short, ErrorGroup> registeredGroups;

    public static synchronized void initialize() {
        for (Class<?> cls : ErrorGroups.class.getDeclaredClasses()) {
            try {
                cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize error groups", e);
            }
        }
    }

    public static synchronized ErrorGroup registerGroup(String groupName, short groupCode) {
        return ErrorGroups.registerGroup(IGNITE_ERR_PREFIX, groupName, groupCode);
    }

    public static synchronized ErrorGroup registerGroup(String errorPrefix, String groupName, short groupCode) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Group name is null or empty");
        }
        String grpName = groupName.toUpperCase(Locale.ENGLISH);
        if (registeredGroups.containsKey(groupCode)) {
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + String.valueOf(registeredGroups.get(groupCode)) + "]");
        }
        for (ErrorGroup group : registeredGroups.values()) {
            if (!group.name().equals(groupName)) continue;
            throw new IllegalArgumentException("Error group already registered [groupName=" + groupName + ", groupCode=" + groupCode + ", registeredGroup=" + String.valueOf(group) + "]");
        }
        if (REGISTERED_ERROR_PREFIXES.add(errorPrefix)) {
            String errorPrefixes = String.join((CharSequence)"|", REGISTERED_ERROR_PREFIXES);
            String pattern = EXCEPTION_MESSAGE_STRING_PATTERN.replace(PLACEHOLDER, errorPrefixes);
            EXCEPTION_MESSAGE_PATTERN = Pattern.compile(pattern, 32);
        }
        ErrorGroup newGroup = new ErrorGroup(errorPrefix, grpName, groupCode);
        registeredGroups.put(groupCode, newGroup);
        return newGroup;
    }

    @Nullable
    public static String extractCauseMessage(String errorMessage) {
        if (errorMessage == null) {
            return null;
        }
        Matcher m = EXCEPTION_MESSAGE_PATTERN.matcher(errorMessage);
        return m.matches() ? m.group(6) : errorMessage;
    }

    public static short extractGroupCode(int code) {
        return (short)(code >>> 16);
    }

    public static ErrorGroup errorGroupByGroupCode(short groupCode) {
        return registeredGroups.get(groupCode);
    }

    public static ErrorGroup errorGroupByCode(int code) {
        ErrorGroup grp = registeredGroups.get(ErrorGroups.extractGroupCode(code));
        assert (grp != null) : "group not found, code=" + code;
        return grp;
    }

    static {
        REGISTERED_ERROR_PREFIXES = new HashSet();
        registeredGroups = new HashMap<Short, ErrorGroup>();
    }

    @ErrorCodeGroup
    public static class CommonConfiguration {
        public static final ErrorGroup COMMON_CONF_ERR_GROUP = ErrorGroups.registerGroup("COMMONCFG", (short)24);
        public static final int CONFIGURATION_APPLY_ERR = COMMON_CONF_ERR_GROUP.registerErrorCode((short)1);
        public static final int CONFIGURATION_PARSE_ERR = COMMON_CONF_ERR_GROUP.registerErrorCode((short)2);
        public static final int CONFIGURATION_VALIDATION_ERR = COMMON_CONF_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class Rest {
        public static final ErrorGroup REST_ERR_GROUP = ErrorGroups.registerGroup("REST", (short)23);
        public static final int CLUSTER_NOT_INIT_ERR = REST_ERR_GROUP.registerErrorCode((short)1);
    }

    @ErrorCodeGroup
    public static class Marshalling {
        public static final ErrorGroup MARSHALLING_ERR_GROUP = ErrorGroups.registerGroup("MARSHALLING", (short)22);
        public static final int COMMON_ERR = MARSHALLING_ERR_GROUP.registerErrorCode((short)1);
        public static final int UNSUPPORTED_OBJECT_TYPE_ERR = MARSHALLING_ERR_GROUP.registerErrorCode((short)2);
        public static final int UNMARSHALLING_ERR = MARSHALLING_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class Embedded {
        public static final ErrorGroup EMBEDDED_ERR_GROUP = ErrorGroups.registerGroup("EMBEDDED", (short)21);
        public static final int CLUSTER_NOT_INITIALIZED_ERR = EMBEDDED_ERR_GROUP.registerErrorCode((short)1);
        public static final int CLUSTER_INIT_FAILED_ERR = EMBEDDED_ERR_GROUP.registerErrorCode((short)2);
        public static final int NODE_NOT_STARTED_ERR = EMBEDDED_ERR_GROUP.registerErrorCode((short)3);
        public static final int NODE_START_ERR = EMBEDDED_ERR_GROUP.registerErrorCode((short)4);
    }

    @ErrorCodeGroup
    public static class DisasterRecovery {
        public static final ErrorGroup RECOVERY_ERR_GROUP = ErrorGroups.registerGroup("RECOVERY", (short)20);
        public static final int ILLEGAL_PARTITION_ID_ERR = RECOVERY_ERR_GROUP.registerErrorCode((short)1);
        public static final int NODES_NOT_FOUND_ERR = RECOVERY_ERR_GROUP.registerErrorCode((short)2);
        public static final int PARTITION_STATE_ERR = RECOVERY_ERR_GROUP.registerErrorCode((short)3);
        public static final int CLUSTER_NOT_IDLE_ERR = RECOVERY_ERR_GROUP.registerErrorCode((short)4);
        public static final int RESTART_WITH_CLEAN_UP_ERR = RECOVERY_ERR_GROUP.registerErrorCode((short)5);
    }

    @ErrorCodeGroup
    public static class CriticalWorkers {
        public static final ErrorGroup CRITICAL_WORKERS_ERR_GROUP = ErrorGroups.registerGroup("WORKERS", (short)19);
        public static final int SYSTEM_WORKER_BLOCKED_ERR = CRITICAL_WORKERS_ERR_GROUP.registerErrorCode((short)1);
        public static final int SYSTEM_CRITICAL_OPERATION_TIMEOUT_ERR = CRITICAL_WORKERS_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class PlacementDriver {
        public static final ErrorGroup PLACEMENT_DRIVER_ERR_GROUP = ErrorGroups.registerGroup("PLACEMENTDRIVER", (short)18);
        public static final int PRIMARY_REPLICA_AWAIT_TIMEOUT_ERR = PLACEMENT_DRIVER_ERR_GROUP.registerErrorCode((short)1);
        public static final int PRIMARY_REPLICA_AWAIT_ERR = PLACEMENT_DRIVER_ERR_GROUP.registerErrorCode((short)2);
        public static final int EMPTY_ASSIGNMENTS_ERR = PLACEMENT_DRIVER_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class Catalog {
        public static final ErrorGroup CATALOG_ERR_GROUP = ErrorGroups.registerGroup("CATALOG", (short)17);
        public static final int VALIDATION_ERR = CATALOG_ERR_GROUP.registerErrorCode((short)1);
    }

    @ErrorCodeGroup
    public static class Compute {
        public static final ErrorGroup COMPUTE_ERR_GROUP = ErrorGroups.registerGroup("COMPUTE", (short)16);
        public static final int CLASS_PATH_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)1);
        public static final int CLASS_LOADER_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)2);
        public static final int CLASS_INITIALIZATION_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)3);
        public static final int QUEUE_OVERFLOW_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)4);
        public static final int COMPUTE_JOB_STATUS_TRANSITION_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)5);
        public static final int CANCELLING_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)6);
        public static final int RESULT_NOT_FOUND_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)7);
        public static final int FAIL_TO_GET_JOB_STATE_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)8);
        public static final int COMPUTE_JOB_FAILED_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)9);
        public static final int PRIMARY_REPLICA_RESOLVE_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)10);
        public static final int CHANGE_JOB_PRIORITY_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)11);
        public static final int NODE_NOT_FOUND_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)12);
        public static final int MARSHALLING_TYPE_MISMATCH_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)13);
        public static final int COMPUTE_JOB_CANCELLED_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)14);
        public static final int COMPUTE_PLATFORM_EXECUTOR_ERR = COMPUTE_ERR_GROUP.registerErrorCode((short)15);
    }

    @ErrorCodeGroup
    public static class Authentication {
        public static final ErrorGroup AUTHENTICATION_ERR_GROUP = ErrorGroups.registerGroup("AUTHENTICATION", (short)15);
        public static final int UNSUPPORTED_AUTHENTICATION_TYPE_ERR = AUTHENTICATION_ERR_GROUP.registerErrorCode((short)1);
        public static final int INVALID_CREDENTIALS_ERR = AUTHENTICATION_ERR_GROUP.registerErrorCode((short)2);
        public static final int BASIC_PROVIDER_ERR = AUTHENTICATION_ERR_GROUP.registerErrorCode((short)3);
    }

    @ErrorCodeGroup
    public static class GarbageCollector {
        public static final ErrorGroup GC_ERR_GROUP = ErrorGroups.registerGroup("GC", (short)14);
        public static final int CLOSED_ERR = GC_ERR_GROUP.registerErrorCode((short)1);
    }

    @ErrorCodeGroup
    public static class CodeDeployment {
        public static final ErrorGroup CODE_DEPLOYMENT_ERR_GROUP = ErrorGroups.registerGroup("CODEDEPLOY", (short)13);
        public static final int UNIT_NOT_FOUND_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)1);
        public static final int UNIT_ALREADY_EXISTS_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)2);
        public static final int UNIT_CONTENT_READ_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)3);
        public static final int UNIT_UNAVAILABLE_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)4);
        public static final int UNIT_ZIP_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)5);
        public static final int UNIT_WRITE_ERR = CODE_DEPLOYMENT_ERR_GROUP.registerErrorCode((short)6);
    }

    @ErrorCodeGroup
    public static class NodeConfiguration {
        public static final ErrorGroup NODE_CONFIGURATION_ERR_GROUP = ErrorGroups.registerGroup("NODECFG", (short)12);
        public static final int CONFIG_READ_ERR = NODE_CONFIGURATION_ERR_GROUP.registerErrorCode((short)1);
        public static final int CONFIG_FILE_CREATE_ERR = NODE_CONFIGURATION_ERR_GROUP.registerErrorCode((short)2);
        public static final int CONFIG_WRITE_ERR = NODE_CONFIGURATION_ERR_GROUP.registerErrorCode((short)3);
        public static final int CONFIG_PARSE_ERR = NODE_CONFIGURATION_ERR_GROUP.registerErrorCode((short)4);
    }

    @ErrorCodeGroup
    public static class Network {
        public static final ErrorGroup NETWORK_ERR_GROUP = ErrorGroups.registerGroup("NETWORK", (short)11);
        public static final int UNRESOLVABLE_CONSISTENT_ID_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)1);
        public static final int BIND_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)2);
        public static final int FILE_TRANSFER_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)3);
        public static final int FILE_VALIDATION_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)4);
        public static final int RECIPIENT_LEFT_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)5);
        public static final int ADDRESS_UNRESOLVED_ERR = NETWORK_ERR_GROUP.registerErrorCode((short)6);
        @Deprecated
        public static final int PORT_IN_USE_ERR = BIND_ERR;
    }

    @ErrorCodeGroup
    public static class DistributionZones {
        public static final ErrorGroup DISTRIBUTION_ZONES_ERR_GROUP = ErrorGroups.registerGroup("DISTRZONES", (short)10);
        public static final int ZONE_NOT_FOUND_ERR = DISTRIBUTION_ZONES_ERR_GROUP.registerErrorCode((short)1);
        public static final int EMPTY_DATA_NODES_ERR = DISTRIBUTION_ZONES_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class Storage {
        public static final ErrorGroup STORAGE_ERR_GROUP = ErrorGroups.registerGroup("STORAGE", (short)9);
        public static final int INDEX_NOT_BUILT_ERR = STORAGE_ERR_GROUP.registerErrorCode((short)1);
        public static final int STORAGE_CORRUPTED_ERR = STORAGE_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class Replicator {
        public static final ErrorGroup REPLICATOR_ERR_GROUP = ErrorGroups.registerGroup("REP", (short)8);
        public static final int REPLICA_COMMON_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)1);
        public static final int REPLICA_IS_ALREADY_STARTED_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)2);
        public static final int REPLICA_TIMEOUT_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)3);
        public static final int REPLICA_UNSUPPORTED_REQUEST_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)4);
        public static final int REPLICA_UNAVAILABLE_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)5);
        public static final int REPLICA_MISS_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)6);
        public static final int CURSOR_CLOSE_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)7);
        public static final int REPLICA_STOPPING_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)8);
        public static final int GROUP_OVERLOADED_ERR = REPLICATOR_ERR_GROUP.registerErrorCode((short)9);
    }

    @ErrorCodeGroup
    public static class Transactions {
        public static final ErrorGroup TX_ERR_GROUP = ErrorGroups.registerGroup("TX", (short)7);
        public static final int TX_STATE_STORAGE_ERR = TX_ERR_GROUP.registerErrorCode((short)1);
        public static final int TX_STATE_STORAGE_STOPPED_ERR = TX_ERR_GROUP.registerErrorCode((short)2);
        public static final int TX_UNEXPECTED_STATE_ERR = TX_ERR_GROUP.registerErrorCode((short)3);
        public static final int ACQUIRE_LOCK_ERR = TX_ERR_GROUP.registerErrorCode((short)4);
        public static final int ACQUIRE_LOCK_TIMEOUT_ERR = TX_ERR_GROUP.registerErrorCode((short)5);
        public static final int TX_COMMIT_ERR = TX_ERR_GROUP.registerErrorCode((short)6);
        public static final int TX_ROLLBACK_ERR = TX_ERR_GROUP.registerErrorCode((short)7);
        public static final int TX_FAILED_READ_WRITE_OPERATION_ERR = TX_ERR_GROUP.registerErrorCode((short)8);
        public static final int TX_STATE_STORAGE_REBALANCE_ERR = TX_ERR_GROUP.registerErrorCode((short)9);
        public static final int TX_READ_ONLY_TOO_OLD_ERR = TX_ERR_GROUP.registerErrorCode((short)10);
        public static final int TX_INCOMPATIBLE_SCHEMA_ERR = TX_ERR_GROUP.registerErrorCode((short)11);
        public static final int TX_PRIMARY_REPLICA_EXPIRED_ERR = TX_ERR_GROUP.registerErrorCode((short)12);
        public static final int TX_ALREADY_FINISHED_ERR = TX_ERR_GROUP.registerErrorCode((short)13);
        public static final int TX_STALE_OPERATION_ERR = TX_ERR_GROUP.registerErrorCode((short)14);
        public static final int TX_STALE_READ_ONLY_OPERATION_ERR = TX_ERR_GROUP.registerErrorCode((short)15);
        public static final int TX_ALREADY_FINISHED_WITH_TIMEOUT_ERR = TX_ERR_GROUP.registerErrorCode((short)16);
    }

    @Deprecated
    @ErrorCodeGroup
    public static class Index {
        @Deprecated
        public static final ErrorGroup INDEX_ERR_GROUP = ErrorGroups.registerGroup("IDX", (short)6);
        @Deprecated
        public static final int INDEX_NOT_FOUND_ERR = INDEX_ERR_GROUP.registerErrorCode((short)1);
        @Deprecated
        public static final int INDEX_ALREADY_EXISTS_ERR = INDEX_ERR_GROUP.registerErrorCode((short)2);
    }

    @ErrorCodeGroup
    public static class MetaStorage {
        public static final ErrorGroup META_STORAGE_ERR_GROUP = ErrorGroups.registerGroup("META", (short)5);
        public static final int STARTING_STORAGE_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)1);
        public static final int RESTORING_STORAGE_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)2);
        public static final int COMPACTION_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)3);
        public static final int OP_EXECUTION_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)4);
        public static final int OP_EXECUTION_TIMEOUT_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)5);
        public static final int COMPACTED_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)6);
        public static final int DIVERGED_ERR = META_STORAGE_ERR_GROUP.registerErrorCode((short)7);
    }

    @ErrorCodeGroup
    public static class Sql {
        public static final ErrorGroup SQL_ERR_GROUP = ErrorGroups.registerGroup("SQL", (short)4);
        public static final int QUERY_NO_RESULT_SET_ERR = SQL_ERR_GROUP.registerErrorCode((short)1);
        @Deprecated
        public static final int SCHEMA_NOT_FOUND_ERR = SQL_ERR_GROUP.registerErrorCode((short)2);
        public static final int STMT_PARSE_ERR = SQL_ERR_GROUP.registerErrorCode((short)3);
        public static final int STMT_VALIDATION_ERR = SQL_ERR_GROUP.registerErrorCode((short)4);
        public static final int CONSTRAINT_VIOLATION_ERR = SQL_ERR_GROUP.registerErrorCode((short)5);
        public static final int EXECUTION_CANCELLED_ERR = SQL_ERR_GROUP.registerErrorCode((short)6);
        public static final int RUNTIME_ERR = SQL_ERR_GROUP.registerErrorCode((short)7);
        public static final int MAPPING_ERR = SQL_ERR_GROUP.registerErrorCode((short)8);
        public static final int TX_CONTROL_INSIDE_EXTERNAL_TX_ERR = SQL_ERR_GROUP.registerErrorCode((short)9);
    }

    @ErrorCodeGroup
    public static class Client {
        public static final ErrorGroup CLIENT_ERR_GROUP = ErrorGroups.registerGroup("CLIENT", (short)3);
        public static final int CONNECTION_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)1);
        public static final int PROTOCOL_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)2);
        public static final int PROTOCOL_COMPATIBILITY_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)3);
        public static final int TABLE_ID_NOT_FOUND_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)4);
        public static final int CONFIGURATION_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)5);
        public static final int CLUSTER_ID_MISMATCH_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)6);
        public static final int CLIENT_SSL_CONFIGURATION_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)7);
        public static final int HANDSHAKE_HEADER_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)8);
        public static final int SERVER_TO_CLIENT_REQUEST_ERR = CLIENT_ERR_GROUP.registerErrorCode((short)9);
    }

    @ErrorCodeGroup
    public static class Table {
        public static final ErrorGroup TABLE_ERR_GROUP = ErrorGroups.registerGroup("TBL", (short)2);
        @Deprecated
        public static final int TABLE_ALREADY_EXISTS_ERR = TABLE_ERR_GROUP.registerErrorCode((short)1);
        public static final int TABLE_NOT_FOUND_ERR = TABLE_ERR_GROUP.registerErrorCode((short)2);
        @Deprecated
        public static final int COLUMN_ALREADY_EXISTS_ERR = TABLE_ERR_GROUP.registerErrorCode((short)3);
        public static final int COLUMN_NOT_FOUND_ERR = TABLE_ERR_GROUP.registerErrorCode((short)4);
        public static final int SCHEMA_VERSION_MISMATCH_ERR = TABLE_ERR_GROUP.registerErrorCode((short)5);
        public static final int UNSUPPORTED_PARTITION_TYPE_ERR = TABLE_ERR_GROUP.registerErrorCode((short)6);
    }

    @ErrorCodeGroup
    public static class Common {
        public static final ErrorGroup COMMON_ERR_GROUP = ErrorGroups.registerGroup("CMN", (short)1);
        public static final int NODE_STOPPING_ERR = COMMON_ERR_GROUP.registerErrorCode((short)1);
        public static final int COMPONENT_NOT_STARTED_ERR = COMMON_ERR_GROUP.registerErrorCode((short)2);
        public static final int ILLEGAL_ARGUMENT_ERR = COMMON_ERR_GROUP.registerErrorCode((short)3);
        public static final int SSL_CONFIGURATION_ERR = COMMON_ERR_GROUP.registerErrorCode((short)4);
        public static final int NODE_LEFT_ERR = COMMON_ERR_GROUP.registerErrorCode((short)5);
        public static final int CURSOR_ALREADY_CLOSED_ERR = COMMON_ERR_GROUP.registerErrorCode((short)6);
        public static final int RESOURCE_CLOSING_ERR = COMMON_ERR_GROUP.registerErrorCode((short)7);
        public static final int USER_OBJECT_SERIALIZATION_ERR = COMMON_ERR_GROUP.registerErrorCode((short)8);
        public static final int NULLABLE_VALUE_ERR = COMMON_ERR_GROUP.registerErrorCode((short)9);
        public static final int INTERNAL_ERR = COMMON_ERR_GROUP.registerErrorCode((short)-1);
    }
}

