/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.statistics.DurationTracker;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public class AbfsOutputStreamStatisticsImpl
implements AbfsOutputStreamStatistics {
    private final IOStatisticsStore ioStatisticsStore = IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{"bytes_upload", "bytes_upload_successfully", "bytes_upload_failed", "queue_shrunk_ops", "write_current_buffer_ops", "blocks_allocated", "blocks_released"}).withDurationTracking(new String[]{"time_spent_on_put_request", "time_spent_task_wait"}).build();
    private final AtomicLong bytesUpload = this.ioStatisticsStore.getCounterReference("bytes_upload");
    private final AtomicLong bytesUploadedSuccessfully = this.ioStatisticsStore.getCounterReference("bytes_upload_successfully");
    private final AtomicLong writeCurrentBufferOps = this.ioStatisticsStore.getCounterReference("write_current_buffer_ops");
    private final AtomicLong blocksAllocated = this.ioStatisticsStore.getCounterReference("blocks_allocated");
    private final AtomicLong blocksReleased = this.ioStatisticsStore.getCounterReference("blocks_released");

    @Override
    public void bytesToUpload(long bytes) {
        this.bytesUpload.addAndGet(bytes);
    }

    @Override
    public void uploadSuccessful(long bytes) {
        this.bytesUploadedSuccessfully.addAndGet(bytes);
    }

    @Override
    public void uploadFailed(long bytes) {
        this.ioStatisticsStore.incrementCounter("bytes_upload_failed", bytes);
    }

    @Override
    public DurationTracker timeSpentTaskWait() {
        return this.ioStatisticsStore.trackDuration("time_spent_task_wait");
    }

    @Override
    public void queueShrunk() {
        this.ioStatisticsStore.incrementCounter("queue_shrunk_ops");
    }

    @Override
    public void writeCurrentBuffer() {
        this.writeCurrentBufferOps.incrementAndGet();
    }

    public void blockAllocated() {
        this.blocksAllocated.incrementAndGet();
    }

    public void blockReleased() {
        this.blocksReleased.incrementAndGet();
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatisticsStore;
    }

    @VisibleForTesting
    public long getBytesToUpload() {
        return (Long)this.ioStatisticsStore.counters().get("bytes_upload");
    }

    @VisibleForTesting
    public long getBytesUploadSuccessful() {
        return (Long)this.ioStatisticsStore.counters().get("bytes_upload_successfully");
    }

    @VisibleForTesting
    public long getBytesUploadFailed() {
        return (Long)this.ioStatisticsStore.counters().get("bytes_upload_failed");
    }

    @VisibleForTesting
    public long getTimeSpentOnTaskWait() {
        return (Long)this.ioStatisticsStore.counters().get("time_spent_task_wait");
    }

    @VisibleForTesting
    public long getQueueShrunkOps() {
        return (Long)this.ioStatisticsStore.counters().get("queue_shrunk_ops");
    }

    @VisibleForTesting
    public long getWriteCurrentBufferOperations() {
        return (Long)this.ioStatisticsStore.counters().get("write_current_buffer_ops");
    }

    @VisibleForTesting
    public double getTimeSpentOnPutRequest() {
        return ((MeanStatistic)this.ioStatisticsStore.meanStatistics().get("time_spent_on_put_request.mean")).mean();
    }

    @Override
    public String toString() {
        StringBuilder outputStreamStats = new StringBuilder("OutputStream Statistics{");
        outputStreamStats.append(this.ioStatisticsStore.toString());
        outputStreamStats.append("}");
        return outputStreamStats.toString();
    }
}

