/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStreamStatistics;
import org.apache.hadoop.fs.azurebfs.services.BlockEntry;
import org.apache.hadoop.fs.store.BlockUploadStatistics;
import org.apache.hadoop.fs.store.DataBlocks;

public class AbfsBlock
implements Closeable {
    private final DataBlocks.DataBlock activeBlock;
    private AbfsOutputStream outputStream;
    private final long offset;
    private BlockEntry blockEntry;

    AbfsBlock(AbfsOutputStream outputStream, long offset) throws IOException {
        this.outputStream = outputStream;
        this.offset = offset;
        DataBlocks.BlockFactory blockFactory = outputStream.getBlockManager().getBlockFactory();
        long blockCount = outputStream.getBlockManager().getBlockCount();
        int blockSize = outputStream.getBlockManager().getBlockSize();
        AbfsOutputStreamStatistics outputStreamStatistics = outputStream.getOutputStreamStatistics();
        this.activeBlock = blockFactory.create(blockCount, blockSize, (BlockUploadStatistics)outputStreamStatistics);
    }

    public int dataSize() {
        return this.activeBlock.dataSize();
    }

    public DataBlocks.BlockUploadData startUpload() throws IOException {
        return this.activeBlock.startUpload();
    }

    public boolean hasData() {
        return this.activeBlock.hasData();
    }

    public int write(byte[] buffer, int offset, int length) throws IOException {
        return this.activeBlock.write(buffer, offset, length);
    }

    public int remainingCapacity() {
        return this.activeBlock.remainingCapacity();
    }

    public Long getOffset() {
        return this.offset;
    }

    @Override
    public void close() throws IOException {
        if (this.activeBlock != null) {
            this.activeBlock.close();
        }
    }

    public String getBlockId() {
        throw new IllegalArgumentException("DFS client does not support blockId");
    }

    public AbfsOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(AbfsOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public BlockEntry getBlockEntry() {
        return this.blockEntry;
    }

    public void setBlockEntry(BlockEntry blockEntry) {
        this.blockEntry = blockEntry;
    }
}

