/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedStripedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockIdManager;
import org.apache.hadoop.hdfs.util.StripedBlockUtil;
import org.apache.hadoop.util.Preconditions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestStripedBlockUtil {
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final short groupSize = (short)(this.dataBlocks + this.parityBlocks);
    private final int cellSize = this.ecPolicy.getCellSize();
    private final int stripeSize = this.dataBlocks * this.cellSize;
    private final int stripesPerBlock = 16;
    private final Random random = new Random();
    private int[] blockGroupSizes;
    private int[] byteRangeStartOffsets;
    private int[] byteRangeSizes;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    @Before
    public void setup() {
        this.blockGroupSizes = new int[]{1, this.getDelta(this.cellSize), this.cellSize, this.getDelta(this.dataBlocks) * this.cellSize, this.getDelta(this.dataBlocks) * this.cellSize + this.getDelta(this.cellSize), this.stripeSize, this.stripeSize + this.getDelta(this.cellSize), this.stripeSize + this.getDelta(this.dataBlocks) * this.cellSize, this.stripeSize + this.getDelta(this.dataBlocks) * this.cellSize + this.getDelta(this.cellSize), this.getDelta(16) * this.stripeSize, 16 * this.stripeSize};
        this.byteRangeStartOffsets = new int[]{0, this.getDelta(this.cellSize), this.cellSize - 1};
        this.byteRangeSizes = new int[]{1, this.getDelta(this.cellSize), this.cellSize, this.getDelta(this.dataBlocks) * this.cellSize, this.getDelta(this.dataBlocks) * this.cellSize + this.getDelta(this.cellSize), this.stripeSize, this.stripeSize + this.getDelta(this.cellSize), this.stripeSize + this.getDelta(this.dataBlocks) * this.cellSize, this.stripeSize + this.getDelta(this.dataBlocks) * this.cellSize + this.getDelta(this.cellSize), this.getDelta(16) * this.stripeSize, 16 * this.stripeSize};
    }

    private int getDelta(int size) {
        return 1 + this.random.nextInt(size - 2);
    }

    private byte hashIntToByte(int i) {
        int BYTE_MASK = 255;
        return (byte)((i + 13) * 29 & BYTE_MASK);
    }

    private LocatedStripedBlock createDummyLocatedBlock(long bgSize) {
        long blockGroupID = -1048576L;
        DatanodeInfo[] locs = new DatanodeInfo[this.groupSize];
        String[] storageIDs = new String[this.groupSize];
        StorageType[] storageTypes = new StorageType[this.groupSize];
        byte[] indices = new byte[this.groupSize];
        for (int i = 0; i < this.groupSize; ++i) {
            indices[i] = (byte)((i + 2) % this.dataBlocks);
            locs[i] = DFSTestUtil.getLocalDatanodeInfo(indices[i]);
            storageIDs[i] = locs[i].getDatanodeUuid();
            storageTypes[i] = StorageType.DISK;
        }
        return new LocatedStripedBlock(new ExtendedBlock("pool", -1048576L, bgSize, 1001L), locs, storageIDs, storageTypes, indices, 0L, false, null);
    }

    private byte[][] createInternalBlkBuffers(int bgSize) {
        int size;
        byte[][] bufs = new byte[this.dataBlocks + this.parityBlocks][];
        int[] pos = new int[this.dataBlocks + this.parityBlocks];
        for (int i = 0; i < this.dataBlocks + this.parityBlocks; ++i) {
            int bufSize = (int)StripedBlockUtil.getInternalBlockLength((long)bgSize, (int)this.cellSize, (int)this.dataBlocks, (int)i);
            bufs[i] = new byte[bufSize];
            pos[i] = 0;
        }
        for (int done = 0; done < bgSize; done += size) {
            Preconditions.checkState((done % this.cellSize == 0 ? 1 : 0) != 0);
            StripedBlockUtil.StripingCell cell = new StripedBlockUtil.StripingCell(this.ecPolicy, this.cellSize, (long)(done / this.cellSize), 0L);
            int idxInStripe = cell.getIdxInStripe();
            size = Math.min(this.cellSize, bgSize - done);
            for (int i = 0; i < size; ++i) {
                bufs[idxInStripe][pos[idxInStripe] + i] = this.hashIntToByte(done + i);
            }
            int n = idxInStripe;
            pos[n] = pos[n] + size;
        }
        return bufs;
    }

    @Test
    public void testLocatedStripedBlockType() {
        LocatedStripedBlock lsb = new LocatedStripedBlock(null, null, null, null, null, 0L, false, null);
        Assert.assertEquals((Object)BlockType.STRIPED, (Object)lsb.getBlockType());
    }

    @Test
    public void testParseDummyStripedBlock() {
        LocatedStripedBlock lsb = this.createDummyLocatedBlock(this.stripeSize * 16);
        LocatedBlock[] blocks = StripedBlockUtil.parseStripedBlockGroup((LocatedStripedBlock)lsb, (int)this.cellSize, (int)this.dataBlocks, (int)this.parityBlocks);
        Assert.assertEquals((long)(this.dataBlocks + this.parityBlocks), (long)blocks.length);
        for (int i = 0; i < this.dataBlocks; ++i) {
            Assert.assertFalse((boolean)blocks[i].isStriped());
            Assert.assertEquals((long)i, (long)BlockIdManager.getBlockIndex((Block)blocks[i].getBlock().getLocalBlock()));
            Assert.assertEquals((long)0L, (long)blocks[i].getStartOffset());
            Assert.assertEquals((long)1L, (long)blocks[i].getLocations().length);
            Assert.assertEquals((long)i, (long)blocks[i].getLocations()[0].getIpcPort());
            Assert.assertEquals((long)i, (long)blocks[i].getLocations()[0].getXferPort());
        }
    }

    private void verifyInternalBlocks(int numBytesInGroup, int[] expected) {
        for (int i = 1; i < this.groupSize; ++i) {
            Assert.assertEquals((long)expected[i], (long)StripedBlockUtil.getInternalBlockLength((long)numBytesInGroup, (int)this.cellSize, (int)this.dataBlocks, (int)i));
        }
    }

    @Test
    public void testGetInternalBlockLength() {
        int delta = 10;
        this.verifyInternalBlocks(this.cellSize - 10, new int[]{this.cellSize - 10, 0, 0, 0, 0, 0, this.cellSize - 10, this.cellSize - 10, this.cellSize - 10});
        this.verifyInternalBlocks(this.cellSize, new int[]{this.cellSize, 0, 0, 0, 0, 0, this.cellSize, this.cellSize, this.cellSize});
        this.verifyInternalBlocks(this.cellSize + 10, new int[]{this.cellSize, 10, 0, 0, 0, 0, this.cellSize, this.cellSize, this.cellSize});
        this.verifyInternalBlocks(2 * this.dataBlocks * this.cellSize, new int[]{2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize});
        this.verifyInternalBlocks(2 * this.dataBlocks * this.cellSize + this.cellSize, new int[]{3 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 3 * this.cellSize, 3 * this.cellSize, 3 * this.cellSize});
        this.verifyInternalBlocks(2 * this.dataBlocks * this.cellSize - 10, new int[]{2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize - 10, 2 * this.cellSize, 2 * this.cellSize, 2 * this.cellSize});
    }

    @Test
    public void testDivideByteRangeIntoStripes() {
        ByteBuffer assembled = ByteBuffer.allocate(16 * this.stripeSize);
        for (int bgSize : this.blockGroupSizes) {
            LocatedStripedBlock blockGroup = this.createDummyLocatedBlock(bgSize);
            byte[][] internalBlkBufs = this.createInternalBlkBuffers(bgSize);
            for (int brStart : this.byteRangeStartOffsets) {
                for (int brSize : this.byteRangeSizes) {
                    StripedBlockUtil.AlignedStripe[] stripes;
                    if (brStart + brSize > bgSize) continue;
                    for (StripedBlockUtil.AlignedStripe stripe : stripes = StripedBlockUtil.divideByteRangeIntoStripes((ErasureCodingPolicy)this.ecPolicy, (int)this.cellSize, (LocatedStripedBlock)blockGroup, (long)brStart, (long)(brStart + brSize - 1), (ByteBuffer)assembled)) {
                        for (int i = 0; i < this.dataBlocks; ++i) {
                            StripedBlockUtil.StripingChunk chunk = stripe.chunks[i];
                            if (chunk == null || chunk.state != 8) continue;
                            int done = 0;
                            for (ByteBuffer slice : chunk.getChunkBuffer().getSlices()) {
                                int len = slice.remaining();
                                slice.put(internalBlkBufs[i], (int)stripe.getOffsetInBlock() + done, len);
                                done += len;
                            }
                        }
                    }
                    for (int i = 0; i < brSize; ++i) {
                        if (this.hashIntToByte(brStart + i) != assembled.get(i)) {
                            System.out.println("Oops");
                        }
                        Assert.assertEquals((String)("Byte at " + (brStart + i) + " should be the same"), (long)this.hashIntToByte(brStart + i), (long)assembled.get(i));
                    }
                }
            }
        }
    }

    @Test
    public void testDivideOneStripeLargeBlockSize() {
        ByteBuffer buffer = ByteBuffer.allocate(this.stripeSize);
        long offsetInInternalBlk = Integer.MAX_VALUE / this.cellSize + 10;
        long rangeStartInBlockGroup = offsetInInternalBlk * (long)this.dataBlocks * (long)this.cellSize;
        long rangeEndInBlockGroup = rangeStartInBlockGroup + (long)(this.dataBlocks / 2 * this.cellSize) - 1L;
        long blockGroupSize = 4096L * (long)this.cellSize * (long)this.groupSize;
        LocatedStripedBlock blockGroup = this.createDummyLocatedBlock(blockGroupSize);
        StripedBlockUtil.AlignedStripe[] stripes = StripedBlockUtil.divideOneStripe((ErasureCodingPolicy)this.ecPolicy, (int)this.cellSize, (LocatedStripedBlock)blockGroup, (long)rangeStartInBlockGroup, (long)rangeEndInBlockGroup, (ByteBuffer)buffer);
        long offset = offsetInInternalBlk * (long)this.cellSize;
        Assert.assertTrue((offset > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertEquals((long)offset, (long)stripes[0].range.offsetInBlock);
        Assert.assertEquals((long)1L, (long)stripes.length);
    }
}

